/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class AotServices<T>
implements Iterable<T> {
    public static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring/aot.factories";
    private final List<T> services;
    private final Map<String, T> beans;
    private final Map<T, Source> sources;

    private AotServices(List<T> loaded, Map<String, T> beans2) {
        this.services = this.collectServices(loaded, beans2);
        this.sources = this.collectSources(loaded, beans2.values());
        this.beans = beans2;
    }

    private List<T> collectServices(List<T> loaded, Map<String, T> beans2) {
        ArrayList<T> services = new ArrayList<T>();
        services.addAll(beans2.values());
        services.addAll(loaded);
        AnnotationAwareOrderComparator.sort(services);
        return Collections.unmodifiableList(services);
    }

    private Map<T, Source> collectSources(Collection<T> loaded, Collection<T> beans2) {
        IdentityHashMap sources = new IdentityHashMap();
        loaded.forEach(service -> sources.put(service, Source.SPRING_FACTORIES_LOADER));
        beans2.forEach(service -> sources.put(service, Source.BEAN_FACTORY));
        return Collections.unmodifiableMap(sources);
    }

    public static Loader factories() {
        return AotServices.factories((ClassLoader)null);
    }

    public static Loader factories(@Nullable ClassLoader classLoader) {
        return AotServices.factories(AotServices.getSpringFactoriesLoader(classLoader));
    }

    public static Loader factories(SpringFactoriesLoader springFactoriesLoader) {
        Assert.notNull((Object)springFactoriesLoader, "'springFactoriesLoader' must not be null");
        return new Loader(springFactoriesLoader, null);
    }

    public static Loader factoriesAndBeans(ListableBeanFactory beanFactory) {
        ClassLoader classLoader;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)((Object)beanFactory);
            classLoader = configurableBeanFactory.getBeanClassLoader();
        } else {
            classLoader = null;
        }
        ClassLoader classLoader2 = classLoader;
        return AotServices.factoriesAndBeans(AotServices.getSpringFactoriesLoader(classLoader2), beanFactory);
    }

    public static Loader factoriesAndBeans(SpringFactoriesLoader springFactoriesLoader, ListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, "'beanFactory' must not be null");
        Assert.notNull((Object)springFactoriesLoader, "'springFactoriesLoader' must not be null");
        return new Loader(springFactoriesLoader, beanFactory);
    }

    private static SpringFactoriesLoader getSpringFactoriesLoader(@Nullable ClassLoader classLoader) {
        return SpringFactoriesLoader.forResourceLocation(FACTORIES_RESOURCE_LOCATION, classLoader);
    }

    @Override
    public Iterator<T> iterator() {
        return this.services.iterator();
    }

    public Stream<T> stream() {
        return this.services.stream();
    }

    public List<T> asList() {
        return this.services;
    }

    public @Nullable T findByBeanName(String beanName) {
        return this.beans.get(beanName);
    }

    public Source getSource(T service) {
        Source source2 = this.sources.get(service);
        Assert.state(source2 != null, () -> "Unable to find service " + ObjectUtils.identityToString((Object)source2));
        return source2;
    }

    public static class Loader {
        private final SpringFactoriesLoader springFactoriesLoader;
        private final @Nullable ListableBeanFactory beanFactory;

        Loader(SpringFactoriesLoader springFactoriesLoader, @Nullable ListableBeanFactory beanFactory) {
            this.springFactoriesLoader = springFactoriesLoader;
            this.beanFactory = beanFactory;
        }

        public <T> AotServices<T> load(Class<T> type) {
            return new AotServices<T>(this.springFactoriesLoader.load(type), this.loadBeans(type));
        }

        private <T> Map<String, T> loadBeans(Class<T> type) {
            return this.beanFactory != null ? BeanFactoryUtils.beansOfTypeIncludingAncestors(this.beanFactory, type, true, false) : Collections.emptyMap();
        }
    }

    public static enum Source {
        SPRING_FACTORIES_LOADER,
        BEAN_FACTORY;

    }
}

