/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GeneratedTypeReference;
import org.springframework.javapoet.ClassName;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class ClassNameGenerator {
    private static final String SEPARATOR = "__";
    private static final String AOT_FEATURE = "Aot";
    private final ClassName defaultTarget;
    private final String featureNamePrefix;
    private final Map<String, AtomicInteger> sequenceGenerator;

    public ClassNameGenerator(ClassName defaultTarget) {
        this(defaultTarget, "");
    }

    public ClassNameGenerator(ClassName defaultTarget, String featureNamePrefix) {
        this(defaultTarget, featureNamePrefix, new ConcurrentHashMap<String, AtomicInteger>());
    }

    private ClassNameGenerator(ClassName defaultTarget, String featureNamePrefix, Map<String, AtomicInteger> sequenceGenerator) {
        Assert.notNull((Object)defaultTarget, "'defaultTarget' must not be null");
        this.defaultTarget = defaultTarget;
        this.featureNamePrefix = !StringUtils.hasText(featureNamePrefix) ? "" : featureNamePrefix;
        this.sequenceGenerator = sequenceGenerator;
    }

    String getFeatureNamePrefix() {
        return this.featureNamePrefix;
    }

    public ClassName generateClassName(String featureName, @Nullable ClassName target) {
        return this.generateSequencedClassName(this.getRootName(featureName, target));
    }

    private String getRootName(String featureName, @Nullable ClassName target) {
        Assert.hasLength(featureName, "'featureName' must not be empty");
        featureName = this.clean(featureName);
        ClassName targetToUse = target != null ? target : this.defaultTarget;
        String featureNameToUse = this.featureNamePrefix + featureName;
        return ClassNameGenerator.toName(targetToUse).replace("$", "_") + SEPARATOR + StringUtils.capitalize(featureNameToUse);
    }

    private String clean(String name) {
        StringBuilder clean = new StringBuilder();
        boolean lastNotLetter = true;
        for (char ch : name.toCharArray()) {
            if (!Character.isLetter(ch)) {
                lastNotLetter = true;
                continue;
            }
            clean.append(lastNotLetter ? Character.toUpperCase(ch) : ch);
            lastNotLetter = false;
        }
        return !clean.isEmpty() ? clean.toString() : AOT_FEATURE;
    }

    private ClassName generateSequencedClassName(String name) {
        int sequence2 = this.sequenceGenerator.computeIfAbsent((String)name, key -> new AtomicInteger()).getAndIncrement();
        if (sequence2 > 0) {
            name = (String)name + sequence2;
        }
        return ClassName.get(ClassUtils.getPackageName((String)name), ClassUtils.getShortName((String)name), new String[0]);
    }

    ClassNameGenerator withFeatureNamePrefix(String featureNamePrefix) {
        return new ClassNameGenerator(this.defaultTarget, featureNamePrefix, this.sequenceGenerator);
    }

    private static String toName(ClassName className) {
        return GeneratedTypeReference.of(className).getName();
    }
}

