/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.ProxyProcessorSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.core.SmartClassLoader;

public abstract class AbstractAdvisingBeanPostProcessor
extends ProxyProcessorSupport
implements SmartInstantiationAwareBeanPostProcessor {
    protected @Nullable Advisor advisor;
    protected boolean beforeExistingAdvisors = false;
    private final Map<Class<?>, Boolean> eligibleBeans = new ConcurrentHashMap(256);

    public void setBeforeExistingAdvisors(boolean beforeExistingAdvisors) {
        this.beforeExistingAdvisors = beforeExistingAdvisors;
    }

    @Override
    public Class<?> determineBeanType(Class<?> beanClass, String beanName) {
        if (this.advisor != null && this.isEligible(beanClass)) {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.copyFrom(this);
            proxyFactory.setTargetClass(beanClass);
            if (!proxyFactory.isProxyTargetClass()) {
                this.evaluateProxyInterfaces(beanClass, proxyFactory);
            }
            proxyFactory.addAdvisor(this.advisor);
            this.customizeProxyFactory(proxyFactory);
            ClassLoader classLoader = this.getProxyClassLoader();
            if (classLoader instanceof SmartClassLoader) {
                SmartClassLoader smartClassLoader = (SmartClassLoader)((Object)classLoader);
                if (classLoader != beanClass.getClassLoader()) {
                    classLoader = smartClassLoader.getOriginalClassLoader();
                }
            }
            return proxyFactory.getProxyClass(classLoader);
        }
        return beanClass;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) {
        Advised advised;
        if (this.advisor == null || bean2 instanceof AopInfrastructureBean) {
            return bean2;
        }
        if (bean2 instanceof Advised && !(advised = (Advised)bean2).isFrozen() && this.isEligible(AopUtils.getTargetClass(bean2))) {
            if (this.beforeExistingAdvisors) {
                advised.addAdvisor(0, this.advisor);
            } else {
                if (advised.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE && advised.getAdvisorCount() > 0) {
                    advised.addAdvisor(advised.getAdvisorCount() - 1, this.advisor);
                    return bean2;
                }
                advised.addAdvisor(this.advisor);
            }
            return bean2;
        }
        if (this.isEligible(bean2, beanName)) {
            ProxyFactory proxyFactory = this.prepareProxyFactory(bean2, beanName);
            if (!proxyFactory.isProxyTargetClass() && !proxyFactory.hasUserSuppliedInterfaces()) {
                this.evaluateProxyInterfaces(bean2.getClass(), proxyFactory);
            }
            proxyFactory.addAdvisor(this.advisor);
            this.customizeProxyFactory(proxyFactory);
            proxyFactory.setFrozen(this.isFrozen());
            proxyFactory.setPreFiltered(true);
            ClassLoader classLoader = this.getProxyClassLoader();
            if (classLoader instanceof SmartClassLoader) {
                SmartClassLoader smartClassLoader = (SmartClassLoader)((Object)classLoader);
                if (classLoader != bean2.getClass().getClassLoader()) {
                    classLoader = smartClassLoader.getOriginalClassLoader();
                }
            }
            return proxyFactory.getProxy(classLoader);
        }
        return bean2;
    }

    protected boolean isEligible(Object bean2, String beanName) {
        return this.isEligible(bean2.getClass());
    }

    protected boolean isEligible(Class<?> targetClass) {
        Boolean eligible = this.eligibleBeans.get(targetClass);
        if (eligible != null) {
            return eligible;
        }
        if (this.advisor == null) {
            return false;
        }
        eligible = AopUtils.canApply(this.advisor, targetClass);
        this.eligibleBeans.put(targetClass, eligible);
        return eligible;
    }

    protected ProxyFactory prepareProxyFactory(Object bean2, String beanName) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.copyFrom(this);
        proxyFactory.setFrozen(false);
        proxyFactory.setTarget(bean2);
        return proxyFactory;
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
    }
}

