/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator;
import org.springframework.aop.aspectj.autoproxy.AspectJAwareAdvisorAutoProxyCreator;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.autoproxy.InfrastructureAdvisorAutoProxyCreator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;

public abstract class AopConfigUtils {
    public static final String AUTO_PROXY_CREATOR_BEAN_NAME = "org.springframework.aop.config.internalAutoProxyCreator";
    private static final List<Class<?>> APC_PRIORITY_LIST = new ArrayList(3);

    public static @Nullable BeanDefinition registerAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        return AopConfigUtils.registerAutoProxyCreatorIfNecessary(registry, null);
    }

    public static @Nullable BeanDefinition registerAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, @Nullable Object source2) {
        return AopConfigUtils.registerOrEscalateApcAsRequired(InfrastructureAdvisorAutoProxyCreator.class, registry, source2);
    }

    public static @Nullable BeanDefinition registerAspectJAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        return AopConfigUtils.registerAspectJAutoProxyCreatorIfNecessary(registry, null);
    }

    public static @Nullable BeanDefinition registerAspectJAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, @Nullable Object source2) {
        return AopConfigUtils.registerOrEscalateApcAsRequired(AspectJAwareAdvisorAutoProxyCreator.class, registry, source2);
    }

    public static @Nullable BeanDefinition registerAspectJAnnotationAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        return AopConfigUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary(registry, null);
    }

    public static @Nullable BeanDefinition registerAspectJAnnotationAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, @Nullable Object source2) {
        return AopConfigUtils.registerOrEscalateApcAsRequired(AnnotationAwareAspectJAutoProxyCreator.class, registry, source2);
    }

    public static void forceAutoProxyCreatorToUseClassProxying(BeanDefinitionRegistry registry) {
        AopConfigUtils.defaultProxyConfig(registry).getPropertyValues().add("proxyTargetClass", Boolean.TRUE);
    }

    public static void forceAutoProxyCreatorToExposeProxy(BeanDefinitionRegistry registry) {
        AopConfigUtils.defaultProxyConfig(registry).getPropertyValues().add("exposeProxy", Boolean.TRUE);
    }

    private static BeanDefinition defaultProxyConfig(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition("org.springframework.aop.framework.autoproxy.defaultProxyConfig")) {
            return registry.getBeanDefinition("org.springframework.aop.framework.autoproxy.defaultProxyConfig");
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(ProxyConfig.class);
        beanDefinition.setSource(AopConfigUtils.class);
        beanDefinition.setRole(2);
        registry.registerBeanDefinition("org.springframework.aop.framework.autoproxy.defaultProxyConfig", beanDefinition);
        return beanDefinition;
    }

    private static @Nullable BeanDefinition registerOrEscalateApcAsRequired(Class<?> cls, BeanDefinitionRegistry registry, @Nullable Object source2) {
        Assert.notNull((Object)registry, "BeanDefinitionRegistry must not be null");
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            int requiredPriority;
            int currentPriority;
            BeanDefinition beanDefinition = registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            if (!cls.getName().equals(beanDefinition.getBeanClassName()) && (currentPriority = AopConfigUtils.findPriorityForClass(beanDefinition.getBeanClassName())) < (requiredPriority = AopConfigUtils.findPriorityForClass(cls))) {
                beanDefinition.setBeanClassName(cls.getName());
            }
            return null;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(cls);
        beanDefinition.setSource(source2);
        beanDefinition.setRole(2);
        beanDefinition.getPropertyValues().add("order", Integer.MIN_VALUE);
        registry.registerBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME, beanDefinition);
        return beanDefinition;
    }

    private static int findPriorityForClass(Class<?> clazz) {
        return APC_PRIORITY_LIST.indexOf(clazz);
    }

    private static int findPriorityForClass(@Nullable String className) {
        for (int i2 = 0; i2 < APC_PRIORITY_LIST.size(); ++i2) {
            Class<?> clazz = APC_PRIORITY_LIST.get(i2);
            if (!clazz.getName().equals(className)) continue;
            return i2;
        }
        throw new IllegalArgumentException("Class name [" + className + "] is not a known auto-proxy creator class");
    }

    static {
        APC_PRIORITY_LIST.add(InfrastructureAdvisorAutoProxyCreator.class);
        APC_PRIORITY_LIST.add(AspectJAwareAdvisorAutoProxyCreator.class);
        APC_PRIORITY_LIST.add(AnnotationAwareAspectJAutoProxyCreator.class);
    }
}

