/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarqube.ws.WsUtils;
import org.sonarqube.ws.client.Headers;
import org.sonarqube.ws.client.Parameters;
import org.sonarqube.ws.client.WsRequest;

abstract class BaseRequest<SELF extends BaseRequest<SELF>>
implements WsRequest {
    private final String path;
    private String mediaType = "application/json";
    private final DefaultParameters parameters = new DefaultParameters();
    private final DefaultHeaders headers = new DefaultHeaders();
    private OptionalInt timeOutInMs = OptionalInt.empty();
    private OptionalInt writeTimeOutInMs = OptionalInt.empty();

    BaseRequest(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public OptionalInt getTimeOutInMs() {
        return this.timeOutInMs;
    }

    public <T extends SELF> T setTimeOutInMs(int timeOutInMs) {
        this.timeOutInMs = OptionalInt.of(timeOutInMs);
        return (T)this;
    }

    @Override
    public OptionalInt getWriteTimeOutInMs() {
        return this.writeTimeOutInMs;
    }

    public <T extends SELF> T setWriteTimeOutInMs(int writeTimeOutInMs) {
        this.writeTimeOutInMs = OptionalInt.of(writeTimeOutInMs);
        return (T)this;
    }

    public <T extends SELF> T setMediaType(String s) {
        Objects.requireNonNull(s, "media type of response cannot be null");
        this.mediaType = s;
        return (T)this;
    }

    public <T extends SELF> T setParam(String key, @Nullable String value) {
        return this.setSingleValueParam(key, value);
    }

    public <T extends SELF> T setParam(String key, @Nullable Integer value) {
        return this.setSingleValueParam(key, value);
    }

    public <T extends SELF> T setParam(String key, @Nullable Long value) {
        return this.setSingleValueParam(key, value);
    }

    public <T extends SELF> T setParam(String key, @Nullable Float value) {
        return this.setSingleValueParam(key, value);
    }

    public <T extends SELF> T setParam(String key, @Nullable Boolean value) {
        return this.setSingleValueParam(key, value);
    }

    private <T extends SELF> T setSingleValueParam(String key, @Nullable Object value) {
        WsUtils.checkArgument(!WsUtils.isNullOrEmpty(key), "a WS parameter key cannot be null", new Object[0]);
        if (value == null) {
            return (T)this;
        }
        this.parameters.setValue(key, value.toString());
        return (T)this;
    }

    public <T extends SELF> T setParam(String key, @Nullable Collection<? extends Object> values2) {
        WsUtils.checkArgument(!WsUtils.isNullOrEmpty(key), "a WS parameter key cannot be null", new Object[0]);
        if (values2 == null || values2.isEmpty()) {
            return (T)this;
        }
        this.parameters.setValues(key, values2.stream().filter(Objects::nonNull).map(Object::toString).toList());
        return (T)this;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    public <T extends SELF> T setHeader(String name, @Nullable String value) {
        Objects.requireNonNull(name, "Header name can't be null");
        this.headers.setValue(name, value);
        return (T)this;
    }

    private static class DefaultParameters
    implements Parameters {
        private final Map<String, List<String>> keyValues = new LinkedHashMap<String, List<String>>();

        private DefaultParameters() {
        }

        @Override
        @CheckForNull
        public String getValue(String key) {
            return this.keyValues.containsKey(key) ? this.keyValues.get(key).get(0) : null;
        }

        @Override
        public List<String> getValues(String key) {
            return this.keyValues.containsKey(key) ? this.keyValues.get(key) : Collections.emptyList();
        }

        @Override
        public Set<String> getKeys() {
            return this.keyValues.keySet();
        }

        private DefaultParameters setValue(String key, String value) {
            WsUtils.checkArgument(!WsUtils.isNullOrEmpty(key));
            WsUtils.checkArgument(value != null);
            this.keyValues.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        private DefaultParameters setValues(String key, Collection<String> values2) {
            WsUtils.checkArgument(!WsUtils.isNullOrEmpty(key));
            WsUtils.checkArgument(values2 != null && !values2.isEmpty());
            this.keyValues.computeIfAbsent(key, k -> new ArrayList()).addAll(values2.stream().map(Object::toString).filter(Objects::nonNull).toList());
            return this;
        }
    }

    private static class DefaultHeaders
    implements Headers {
        private final Map<String, String> keyValues = new HashMap<String, String>();

        private DefaultHeaders() {
        }

        @Override
        public Optional<String> getValue(String name) {
            return Optional.ofNullable(this.keyValues.get(name));
        }

        private DefaultHeaders setValue(String name, @Nullable String value) {
            WsUtils.checkArgument(!WsUtils.isNullOrEmpty(name));
            if (value == null) {
                this.keyValues.remove(name);
            } else {
                this.keyValues.put(name, value);
            }
            return this;
        }

        @Override
        public Set<String> getNames() {
            return Collections.unmodifiableSet(this.keyValues.keySet());
        }
    }
}

