/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.sonar.updatecenter.common.FormatUtils;
import org.sonar.updatecenter.common.PluginKeyUtils;

public final class PluginManifest {
    public static final String KEY = "Plugin-Key";
    public static final String MAIN_CLASS = "Plugin-Class";
    public static final String NAME = "Plugin-Name";
    public static final String DESCRIPTION = "Plugin-Description";
    public static final String ORGANIZATION = "Plugin-Organization";
    public static final String ORGANIZATION_URL = "Plugin-OrganizationUrl";
    public static final String LICENSE = "Plugin-License";
    public static final String VERSION = "Plugin-Version";
    public static final String SONAR_VERSION = "Sonar-Version";
    public static final String DEPENDENCIES = "Plugin-Dependencies";
    public static final String HOMEPAGE = "Plugin-Homepage";
    public static final String TERMS_CONDITIONS_URL = "Plugin-TermsConditionsUrl";
    public static final String BUILD_DATE = "Plugin-BuildDate";
    public static final String ISSUE_TRACKER_URL = "Plugin-IssueTrackerUrl";
    public static final String REQUIRE_PLUGINS = "Plugin-RequirePlugins";
    public static final String USE_CHILD_FIRST_CLASSLOADER = "Plugin-ChildFirstClassLoader";
    public static final String BASE_PLUGIN = "Plugin-Base";
    public static final String IMPLEMENTATION_BUILD = "Implementation-Build";
    public static final String SOURCES_URL = "Plugin-SourcesUrl";
    public static final String DEVELOPERS = "Plugin-Developers";
    public static final String SONARLINT_SUPPORTED = "SonarLint-Supported";
    public static final String DISPLAY_VERSION = "Plugin-Display-Version";
    public static final String REQUIRED_FOR_LANGUAGES = "Plugin-RequiredForLanguages";
    private String key;
    private String name;
    private String mainClass;
    private String description;
    private String organization;
    private String organizationUrl;
    private String license;
    private String version;
    private String displayVersion;
    private String sonarVersion;
    private String[] dependencies = new String[0];
    private String homepage;
    private String termsConditionsUrl;
    private Date buildDate;
    private String issueTrackerUrl;
    private boolean useChildFirstClassLoader = false;
    private String basePlugin;
    private String implementationBuild;
    private String sourcesUrl;
    private String[] developers = new String[0];
    private String[] requirePlugins = new String[0];
    private boolean sonarlintSupported;
    private String[] requiredForLanguages;

    public PluginManifest(File file) throws IOException {
        this();
        try (JarFile jar = new JarFile(file);){
            if (jar.getManifest() != null) {
                this.loadManifest(jar.getManifest());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read plugin manifest from jar : " + file.getAbsolutePath(), e);
        }
    }

    public PluginManifest(Manifest manifest) {
        this();
        this.loadManifest(manifest);
    }

    public PluginManifest() {
    }

    private void loadManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.key = PluginKeyUtils.sanitize(attributes.getValue(KEY));
        this.mainClass = attributes.getValue(MAIN_CLASS);
        this.name = attributes.getValue(NAME);
        this.description = attributes.getValue(DESCRIPTION);
        this.license = attributes.getValue(LICENSE);
        this.organization = attributes.getValue(ORGANIZATION);
        this.organizationUrl = attributes.getValue(ORGANIZATION_URL);
        this.version = attributes.getValue(VERSION);
        this.displayVersion = attributes.getValue(DISPLAY_VERSION);
        this.homepage = attributes.getValue(HOMEPAGE);
        this.termsConditionsUrl = attributes.getValue(TERMS_CONDITIONS_URL);
        this.sonarVersion = attributes.getValue(SONAR_VERSION);
        this.issueTrackerUrl = attributes.getValue(ISSUE_TRACKER_URL);
        this.buildDate = FormatUtils.toDateTime(attributes.getValue(BUILD_DATE));
        this.useChildFirstClassLoader = "true".equalsIgnoreCase(attributes.getValue(USE_CHILD_FIRST_CLASSLOADER));
        this.sonarlintSupported = "true".equalsIgnoreCase(attributes.getValue(SONARLINT_SUPPORTED));
        this.basePlugin = attributes.getValue(BASE_PLUGIN);
        this.implementationBuild = attributes.getValue(IMPLEMENTATION_BUILD);
        this.sourcesUrl = attributes.getValue(SOURCES_URL);
        String deps = attributes.getValue(DEPENDENCIES);
        this.dependencies = StringUtils.split(StringUtils.defaultString(deps), ' ');
        String devs = attributes.getValue(DEVELOPERS);
        this.developers = StringUtils.split(StringUtils.defaultString(devs), ',');
        String requires = attributes.getValue(REQUIRE_PLUGINS);
        this.requirePlugins = StringUtils.split(StringUtils.defaultString(requires), ',');
        String languages = attributes.getValue(REQUIRED_FOR_LANGUAGES);
        this.requiredForLanguages = StringUtils.split(StringUtils.defaultString(languages), ',');
    }

    public String getKey() {
        return this.key;
    }

    public PluginManifest setKey(String key) {
        this.key = key;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public PluginManifest setName(String name) {
        this.name = name;
        return this;
    }

    public String[] getRequirePlugins() {
        return this.requirePlugins != null ? (String[])this.requirePlugins.clone() : null;
    }

    public PluginManifest setRequirePlugins(@Nullable String[] requirePlugins) {
        this.requirePlugins = requirePlugins != null ? (String[])requirePlugins.clone() : null;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public PluginManifest setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getOrganization() {
        return this.organization;
    }

    public PluginManifest setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public PluginManifest setOrganizationUrl(String url) {
        this.organizationUrl = url;
        return this;
    }

    public String getLicense() {
        return this.license;
    }

    public PluginManifest setLicense(String license) {
        this.license = license;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public PluginManifest setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getDisplayVersion() {
        return this.displayVersion;
    }

    public PluginManifest setDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
        return this;
    }

    public String getSonarVersion() {
        return this.sonarVersion;
    }

    public PluginManifest setSonarVersion(String sonarVersion) {
        this.sonarVersion = sonarVersion;
        return this;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public PluginManifest setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public String[] getDependencies() {
        return this.dependencies != null ? (String[])this.dependencies.clone() : null;
    }

    public PluginManifest setDependencies(@Nullable String[] dependencies) {
        this.dependencies = dependencies != null ? (String[])dependencies.clone() : null;
        return this;
    }

    public Date getBuildDate() {
        return this.buildDate != null ? new Date(this.buildDate.getTime()) : null;
    }

    public PluginManifest setBuildDate(@Nullable Date buildDate) {
        this.buildDate = buildDate != null ? new Date(buildDate.getTime()) : null;
        return this;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public PluginManifest setHomepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    public String getTermsConditionsUrl() {
        return this.termsConditionsUrl;
    }

    public PluginManifest setTermsConditionsUrl(String termsConditionsUrl) {
        this.termsConditionsUrl = termsConditionsUrl;
        return this;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public PluginManifest setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
        return this;
    }

    public boolean isUseChildFirstClassLoader() {
        return this.useChildFirstClassLoader;
    }

    public PluginManifest setUseChildFirstClassLoader(boolean useChildFirstClassLoader) {
        this.useChildFirstClassLoader = useChildFirstClassLoader;
        return this;
    }

    public boolean isSonarLintSupported() {
        return this.sonarlintSupported;
    }

    public PluginManifest setSonarLintSupported(boolean sonarlintSupported) {
        this.sonarlintSupported = sonarlintSupported;
        return this;
    }

    public String getBasePlugin() {
        return this.basePlugin;
    }

    public PluginManifest setBasePlugin(String key) {
        this.basePlugin = key;
        return this;
    }

    public String getImplementationBuild() {
        return this.implementationBuild;
    }

    public PluginManifest setImplementationBuild(String implementationBuild) {
        this.implementationBuild = implementationBuild;
        return this;
    }

    public String getSourcesUrl() {
        return this.sourcesUrl;
    }

    public PluginManifest setSourcesUrl(String sourcesUrl) {
        this.sourcesUrl = sourcesUrl;
        return this;
    }

    public String[] getDevelopers() {
        return this.developers;
    }

    public PluginManifest setDevelopers(String[] developers) {
        this.developers = developers;
        return this;
    }

    public String[] getRequiredForLanguages() {
        return this.requiredForLanguages;
    }

    public PluginManifest setRequiredForLanguages(String[] requiredForLanguages) {
        this.requiredForLanguages = requiredForLanguages;
        return this;
    }

    public String toString() {
        return new ReflectionToStringBuilder(this).toString();
    }

    public boolean isValid() {
        return StringUtils.isNotBlank(this.key) && StringUtils.isNotBlank(this.version);
    }
}

