/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class PluginKeyUtils {
    private static final String SONAR_PLUGIN_SUFFIX = "-sonar-plugin";
    private static final String SONAR_PREFIX = "sonar-";
    private static final String PLUGIN_SUFFIX = "-plugin";

    private PluginKeyUtils() {
    }

    @CheckForNull
    public static String sanitize(@Nullable String mavenArtifactId) {
        if (mavenArtifactId == null) {
            return null;
        }
        String key = mavenArtifactId;
        if (StringUtils.startsWith(mavenArtifactId, SONAR_PREFIX) && StringUtils.endsWith(mavenArtifactId, PLUGIN_SUFFIX)) {
            key = StringUtils.removeEnd(StringUtils.removeStart(mavenArtifactId, SONAR_PREFIX), PLUGIN_SUFFIX);
        } else if (StringUtils.endsWith(mavenArtifactId, SONAR_PLUGIN_SUFFIX)) {
            key = StringUtils.removeEnd(mavenArtifactId, SONAR_PLUGIN_SUFFIX);
        }
        return PluginKeyUtils.keepLettersAndDigits(key);
    }

    private static String keepLettersAndDigits(String key) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < key.length(); ++index) {
            char character = key.charAt(index);
            if (!Character.isLetter(character) && !Character.isDigit(character)) continue;
            sb.append(character);
        }
        return sb.toString();
    }

    public static boolean isValid(String pluginKey) {
        return StringUtils.isNotBlank(pluginKey) && StringUtils.isAlphanumeric(pluginKey);
    }
}

