/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sonar.updatecenter.common.Component;
import org.sonar.updatecenter.common.PluginManifest;

public class Plugin
extends Component {
    private Plugin(String key) {
        super(key);
    }

    public static Plugin factory(String key) {
        if (StringUtils.isAlphanumeric(key)) {
            return new Plugin(key);
        }
        throw new IllegalArgumentException("plugin key must be alphanumeric, strictly");
    }

    @Override
    public Plugin setName(String name) {
        return (Plugin)super.setName(name);
    }

    @Override
    public Plugin setDescription(String description) {
        return (Plugin)super.setDescription(description);
    }

    @Override
    public Plugin setHomepageUrl(String url) {
        return (Plugin)super.setHomepageUrl(url);
    }

    @Override
    public Plugin setLicense(String license) {
        return (Plugin)super.setLicense(license);
    }

    @Override
    public Plugin setOrganization(String organization) {
        return (Plugin)super.setOrganization(organization);
    }

    @Override
    public Plugin setOrganizationUrl(String url) {
        return (Plugin)super.setOrganizationUrl(url);
    }

    @Override
    public Plugin setCategory(String category) {
        return (Plugin)super.setCategory(category);
    }

    @Override
    public Plugin setTermsConditionsUrl(String url) {
        return (Plugin)super.setTermsConditionsUrl(url);
    }

    @Override
    public Plugin setIssueTrackerUrl(String url) {
        return (Plugin)super.setIssueTrackerUrl(url);
    }

    @Override
    public Plugin setSourcesUrl(String sourcesUrl) {
        return (Plugin)super.setSourcesUrl(sourcesUrl);
    }

    public Plugin setDevelopers(List developers) {
        return (Plugin)super.setDevelopers(developers);
    }

    @Override
    boolean needArtifact() {
        return true;
    }

    @Override
    boolean needSqVersion() {
        return true;
    }

    public Plugin merge(PluginManifest manifest) {
        if (StringUtils.equals(this.key, manifest.getKey())) {
            this.name = manifest.getName();
            this.organization = StringUtils.defaultIfEmpty(manifest.getOrganization(), this.organization);
            this.organizationUrl = StringUtils.defaultIfEmpty(manifest.getOrganizationUrl(), this.organizationUrl);
            this.license = StringUtils.defaultIfEmpty(manifest.getLicense(), this.license);
            this.termsConditionsUrl = StringUtils.defaultIfEmpty(manifest.getTermsConditionsUrl(), this.termsConditionsUrl);
            this.developers = Arrays.asList(manifest.getDevelopers());
            this.description = StringUtils.defaultIfEmpty(this.description, manifest.getDescription());
            this.issueTrackerUrl = StringUtils.defaultIfEmpty(this.issueTrackerUrl, manifest.getIssueTrackerUrl());
            this.homepageUrl = StringUtils.defaultIfEmpty(this.homepageUrl, manifest.getHomepage());
            this.sourcesUrl = StringUtils.defaultIfEmpty(this.sourcesUrl, manifest.getSourcesUrl());
        }
        return this;
    }
}

