/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class FormatUtils {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";

    private FormatUtils() {
    }

    public static Date toDate(String s) {
        try {
            if (StringUtils.isNotBlank(s)) {
                return new SimpleDateFormat(DATE_PATTERN).parse(s);
            }
            return null;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The following value does not respect the date pattern yyyy-MM-dd: " + s, e);
        }
    }

    public static Date toDateTime(String s) {
        try {
            if (StringUtils.isNotBlank(s)) {
                return new SimpleDateFormat(DATETIME_PATTERN).parse(s);
            }
            return null;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("The following value does not respect the date pattern yyyy-MM-dd'T'HH:mm:ssZ: " + s, e);
        }
    }

    @CheckForNull
    public static String toDateString(@Nullable Date d) {
        if (d != null) {
            return new SimpleDateFormat(DATE_PATTERN).format(d);
        }
        return null;
    }

    @CheckForNull
    public static String toDateTimeString(@Nullable Date d) {
        if (d != null) {
            return new SimpleDateFormat(DATETIME_PATTERN).format(d);
        }
        return null;
    }
}

