/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.svn;

import java.io.File;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;

public class SvnConfiguration {
    private final Configuration config;

    public SvnConfiguration(Configuration config) {
        this.config = config;
    }

    @CheckForNull
    public String username() {
        return this.config.get("sonar.svn.username").orElse(null);
    }

    @CheckForNull
    public String password() {
        return this.config.get("sonar.svn.password.secured").orElse(null);
    }

    @CheckForNull
    public File privateKey() {
        Optional<String> privateKeyOpt = this.config.get("sonar.svn.privateKeyPath");
        if (privateKeyOpt.isPresent()) {
            File privateKeyFile = new File(privateKeyOpt.get());
            if (!(privateKeyFile.exists() && privateKeyFile.isFile() && privateKeyFile.canRead())) {
                throw MessageException.of("Unable to read private key from '" + String.valueOf(privateKeyFile) + "'");
            }
            return privateKeyFile;
        }
        return null;
    }

    @CheckForNull
    public String passPhrase() {
        return this.config.get("sonar.svn.passphrase.secured").orElse(null);
    }

    public boolean isEmpty() {
        return this.username() == null && this.password() == null && this.privateKey() == null && this.passPhrase() == null;
    }
}

