/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.io.IOException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.scm.git.blame.BlameGenerator;
import org.sonar.scm.git.blame.BlameResult;
import org.sonar.scm.git.blame.BlobReader;
import org.sonar.scm.git.blame.FileBlamer;
import org.sonar.scm.git.blame.FileTreeComparator;
import org.sonar.scm.git.blame.FilteredRenameDetector;
import org.sonar.scm.git.blame.GraphNodeFactory;
import org.sonar.scm.git.blame.diff.RenameDetector;

public class RepositoryBlameCommand
extends GitCommand<BlameResult> {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryBlameCommand.class);
    private DiffAlgorithm diffAlgorithm = new HistogramDiff();
    private RawTextComparator textComparator = RawTextComparator.DEFAULT;
    private ObjectId startCommit = null;
    private Set<String> filePaths = null;
    private boolean multithreading = false;
    private BiConsumer<Integer, String> progressCallBack;
    private UnaryOperator<String> fileContentProvider = null;

    public RepositoryBlameCommand(Repository repo) {
        super(repo);
    }

    public RepositoryBlameCommand setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        return this;
    }

    public RepositoryBlameCommand setMultithreading(boolean multithreading) {
        this.multithreading = multithreading;
        return this;
    }

    public RepositoryBlameCommand setStartCommit(@Nullable AnyObjectId commit) {
        this.startCommit = commit != null ? commit.toObjectId() : null;
        return this;
    }

    public RepositoryBlameCommand setTextComparator(RawTextComparator textComparator) {
        this.textComparator = textComparator;
        return this;
    }

    public RepositoryBlameCommand setFilePaths(@Nullable Set<String> filePaths) {
        this.filePaths = filePaths;
        return this;
    }

    public RepositoryBlameCommand setProgressCallBack(BiConsumer<Integer, String> progressCallBack) {
        this.progressCallBack = progressCallBack;
        return this;
    }

    public RepositoryBlameCommand setFileContentProvider(UnaryOperator<String> fileContentProvider) {
        this.fileContentProvider = fileContentProvider;
        return this;
    }

    @Override
    public BlameResult call() throws GitAPIException {
        BlameResult blameResult = new BlameResult();
        try {
            BlobReader blobReader = new BlobReader(this.repo, this.fileContentProvider);
            FilteredRenameDetector filteredRenameDetector = new FilteredRenameDetector(new RenameDetector(this.repo));
            FileTreeComparator fileTreeComparator = new FileTreeComparator(this.repo, filteredRenameDetector);
            FileBlamer fileBlamer = new FileBlamer(fileTreeComparator, this.diffAlgorithm, this.textComparator, blobReader, blameResult, this.multithreading);
            if (this.filePaths != null && this.filePaths.isEmpty()) {
                return blameResult;
            }
            GraphNodeFactory graphNodeFactory = new GraphNodeFactory(this.repo, this.filePaths);
            BlameGenerator blameGenerator = new BlameGenerator(this.repo, fileBlamer, graphNodeFactory, this.progressCallBack);
            blameGenerator.generateBlame(this.startCommit);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to blame repository files", e);
        }
        return blameResult;
    }
}

