/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.sonar.scm.git.blame.CommitGraphNode;
import org.sonar.scm.git.blame.FileCandidate;
import org.sonar.scm.git.blame.GraphNode;
import org.sonar.scm.git.blame.WorkDirGraphNode;

public class GraphNodeFactory {
    private final Repository repository;
    private final Set<String> filePathsToBlame;

    public GraphNodeFactory(Repository repository, @Nullable Set<String> filePathsToBlame) {
        this.repository = repository;
        this.filePathsToBlame = filePathsToBlame;
    }

    public CommitGraphNode createForCommit(TreeWalk treeWalk, RevCommit commit) throws IOException {
        MutableObjectId idBuf = new MutableObjectId();
        ArrayList<FileCandidate> files = new ArrayList<FileCandidate>();
        treeWalk.setRecursive(true);
        treeWalk.reset((AnyObjectId)commit.getTree());
        while (treeWalk.next()) {
            if (this.filePathsToBlame != null && !this.filePathsToBlame.contains(treeWalk.getPathString()) || !GraphNodeFactory.isFile(treeWalk.getRawMode(0))) continue;
            treeWalk.getObjectId(idBuf, 0);
            files.add(new FileCandidate(treeWalk.getPathString(), treeWalk.getPathString(), idBuf.toObjectId()));
        }
        return new CommitGraphNode(commit, files);
    }

    public GraphNode createForWorkingDir(TreeWalk treeWalk, RevCommit parentCommit) throws IOException {
        Objects.requireNonNull(parentCommit);
        ArrayList<FileCandidate> files = new ArrayList<FileCandidate>();
        treeWalk.setRecursive(true);
        treeWalk.reset();
        if (this.repository.isBare()) {
            treeWalk.addTree(parentCommit.getTree().getId());
        } else {
            treeWalk.addTree(new FileTreeIterator(this.repository));
        }
        while (treeWalk.next()) {
            if (this.filePathsToBlame != null && !this.filePathsToBlame.contains(treeWalk.getPathString()) || !GraphNodeFactory.isFile(treeWalk.getRawMode(0))) continue;
            files.add(new FileCandidate(treeWalk.getPathString(), treeWalk.getPathString(), ObjectId.zeroId()));
        }
        return new WorkDirGraphNode(parentCommit, files);
    }

    private static boolean isFile(int rawMode) {
        return (rawMode & 0xF000) == 32768;
    }
}

