/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.eclipse.jgit.revwalk.RevCommit;
import org.sonar.scm.git.blame.CommitGraphNode;
import org.sonar.scm.git.blame.FileCandidate;

public abstract class GraphNode {
    public static final Comparator<GraphNode> TIME_COMPARATOR = Comparator.comparing(GraphNode::getTime).thenComparing(GraphNode::getCommit, Comparator.nullsFirst(Comparator.naturalOrder())).reversed();
    private final Map<String, List<FileCandidate>> filesByPath;
    private final List<FileCandidate> allFiles;

    GraphNode(int expectedNumFiles) {
        this.filesByPath = new HashMap<String, List<FileCandidate>>(expectedNumFiles);
        this.allFiles = new ArrayList<FileCandidate>(expectedNumFiles);
    }

    GraphNode(List<FileCandidate> files) {
        this.filesByPath = files.stream().collect(Collectors.groupingBy(FileCandidate::getPath));
        this.allFiles = files;
    }

    public Collection<FileCandidate> getFilesByPath(String filePath) {
        return this.filesByPath.getOrDefault(filePath, List.of());
    }

    public Set<String> getAllPaths() {
        return this.filesByPath.keySet();
    }

    public Collection<FileCandidate> getAllFiles() {
        return this.allFiles;
    }

    public void addFile(FileCandidate fileCandidate) {
        this.filesByPath.computeIfAbsent(fileCandidate.getPath(), k -> new LinkedList()).add(fileCandidate);
        this.allFiles.add(fileCandidate);
    }

    @CheckForNull
    public abstract RevCommit getCommit();

    public abstract int getParentCount();

    public abstract RevCommit getParentCommit(int var1);

    public abstract int getTime();

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Commit[");
        if (this.getCommit() != null) {
            r.append(" @ ").append(this.getCommit().abbreviate(6).name());
        }
        r.append("]");
        return r.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitGraphNode that = (CommitGraphNode)o;
        return Objects.equals(this.getCommit(), that.getCommit()) && Objects.equals(this.getTime(), that.getTime());
    }

    public int hashCode() {
        return Objects.hash(this.getCommit(), this.getTime());
    }
}

