/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sonar.scm.git.blame.diff.DiffEntry;
import org.sonar.scm.git.blame.diff.RenameDetector;

public class FilteredRenameDetector {
    private final RenameDetector renameDetector;

    public FilteredRenameDetector(RenameDetector renameDetector) {
        this.renameDetector = renameDetector;
    }

    public List<DiffEntry> detectRenames(Collection<DiffEntry> changes, Set<String> paths) throws IOException {
        ArrayList<DiffEntry> filtered = new ArrayList<DiffEntry>();
        for (DiffEntry diff : changes) {
            DiffEntry.ChangeType changeType = diff.getChangeType();
            if (changeType == DiffEntry.ChangeType.ADD && !paths.contains(diff.getNewPath())) continue;
            filtered.add(diff);
        }
        this.renameDetector.reset();
        this.renameDetector.addAll(filtered);
        return this.renameDetector.compute();
    }
}

