/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.sonar.scm.git.blame.FilteredRenameDetector;
import org.sonar.scm.git.blame.diff.DiffEntry;

public class FileTreeComparator {
    private static final int THRESHOLD_FILTER_FILES = 100;
    private final MutableObjectId idBuf = new MutableObjectId();
    private final Repository repository;
    private final FilteredRenameDetector filteredRenameDetector;
    private TreeWalk treeWalk;
    private TreeFilter filesAndAnyDiffFilter = null;
    private Set<String> filterFilePaths = null;

    public FileTreeComparator(Repository repository, FilteredRenameDetector filteredRenameDetector) {
        this.repository = repository;
        this.filteredRenameDetector = filteredRenameDetector;
    }

    public void initialize(ObjectReader objectReader) {
        this.treeWalk = new TreeWalk(objectReader);
        this.treeWalk.setRecursive(true);
    }

    private List<DiffFile> computeForWorkingDir(RevCommit commit, Set<String> filePaths) throws IOException {
        ArrayList<DiffFile> matchedFiles = new ArrayList<DiffFile>();
        this.treeWalk.reset();
        this.treeWalk.addTree(commit.getTree());
        if (!this.repository.isBare()) {
            this.treeWalk.addTree(new FileTreeIterator(this.repository));
        }
        this.treeWalk.setFilter(TreeFilter.ALL);
        while (this.treeWalk.next()) {
            if (!filePaths.contains(this.treeWalk.getPathString())) continue;
            this.treeWalk.getObjectId(this.idBuf, 0);
            matchedFiles.add(new DiffFile(this.treeWalk.getPathString(), this.treeWalk.getPathString(), this.idBuf.toObjectId()));
        }
        return matchedFiles;
    }

    public List<DiffFile> findMovedFiles(RevCommit parent, @Nullable RevCommit child, Set<String> filePathsToInclude) throws IOException {
        List<DiffFile> modifiedFiles;
        if (child == null) {
            return this.computeForWorkingDir(parent, filePathsToInclude);
        }
        if (filePathsToInclude.size() < 100 && (modifiedFiles = this.findMovedFilesForSmallSet(parent, child, filePathsToInclude)) != null) {
            return modifiedFiles;
        }
        Collection<DiffEntry> diffEntries = this.getDiffEntries(parent, child);
        diffEntries = this.detectRenames(filePathsToInclude, diffEntries);
        return diffEntries.stream().filter(entry -> entry.getChangeType() != DiffEntry.ChangeType.DELETE).filter(entry -> filePathsToInclude.contains(entry.getNewPath())).map(entry -> new DiffFile(entry.getNewPath(), entry.getOldPath(), entry.getOldId().toObjectId())).toList();
    }

    @CheckForNull
    private List<DiffFile> findMovedFilesForSmallSet(RevCommit parent, RevCommit child, Set<String> filePaths) throws IOException {
        if (!filePaths.equals(this.filterFilePaths)) {
            TreeFilter pathFilterGroup = PathFilterGroup.createFromStrings(filePaths);
            this.filesAndAnyDiffFilter = AndTreeFilter.create(pathFilterGroup, TreeFilter.ANY_DIFF);
            this.filterFilePaths = filePaths;
        }
        this.treeWalk.setFilter(this.filesAndAnyDiffFilter);
        this.treeWalk.reset(parent.getTree(), child.getTree());
        ArrayList<DiffFile> movedFiles = new ArrayList<DiffFile>(filePaths.size());
        while (this.treeWalk.next()) {
            if (!filePaths.contains(this.treeWalk.getPathString())) continue;
            this.treeWalk.getObjectId(this.idBuf, 0);
            if (this.isAddedOrNotFile()) {
                return null;
            }
            movedFiles.add(new DiffFile(this.treeWalk.getPathString(), this.treeWalk.getPathString(), this.idBuf.toObjectId()));
        }
        return movedFiles;
    }

    private boolean isAddedOrNotFile() {
        return this.idBuf.equals(ObjectId.zeroId()) || !FileTreeComparator.isFile(this.treeWalk.getRawMode(0));
    }

    private static boolean isFile(int rawMode) {
        return (rawMode & 0xF000) == 32768;
    }

    private Collection<DiffEntry> getDiffEntries(RevCommit parent, RevCommit child) throws IOException {
        this.treeWalk.setFilter(TreeFilter.ANY_DIFF);
        this.treeWalk.reset(parent.getTree(), child.getTree());
        return DiffEntry.scan(this.treeWalk);
    }

    private Collection<DiffEntry> detectRenames(Set<String> newFilePaths, Collection<DiffEntry> diffEntries) throws IOException {
        return this.filteredRenameDetector.detectRenames(diffEntries, newFilePaths);
    }

    public static class DiffFile {
        private final String newPath;
        private final String oldPath;
        private final ObjectId oldObjectId;

        public DiffFile(String newPath, @Nullable String oldPath, ObjectId oldObjectId) {
            this.newPath = newPath;
            this.oldObjectId = oldObjectId;
            this.oldPath = ObjectId.zeroId().equals(oldObjectId) ? null : oldPath;
        }

        public String getNewPath() {
            return this.newPath;
        }

        @CheckForNull
        public String getOldPath() {
            return this.oldPath;
        }

        public ObjectId getOldObjectId() {
            return this.oldObjectId;
        }
    }
}

