/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.lib.ObjectId;
import org.sonar.scm.git.blame.Region;

class FileCandidate {
    private final String originalPath;
    private final String sourcePath;
    private final ObjectId sourceBlob;
    private Region regionList;

    FileCandidate(String originalPath, String path, ObjectId blob) {
        this(originalPath, path, blob, null);
    }

    FileCandidate(String originalPath, String path, ObjectId blob, @Nullable Region regionList) {
        this.originalPath = originalPath;
        this.sourcePath = path;
        this.sourceBlob = blob;
        this.regionList = regionList;
    }

    public ObjectId getBlob() {
        return this.sourceBlob;
    }

    @CheckForNull
    public Region getRegionList() {
        return this.regionList;
    }

    public String getPath() {
        return this.sourcePath;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public void setRegionList(@Nullable Region regionList) {
        this.regionList = regionList;
    }

    void takeBlame(EditList editList, FileCandidate child) {
        FileCandidate.blame(editList, this, child);
    }

    private static void blame(EditList editList, FileCandidate a, FileCandidate b) {
        int d;
        Region r = b.clearRegionList();
        Region aTail = null;
        Region bTail = null;
        int eIdx = 0;
        while (eIdx < editList.size()) {
            if (r == null) {
                return;
            }
            Edit e = (Edit)editList.get(eIdx);
            if (e.getEndB() <= r.sourceStart) {
                ++eIdx;
                continue;
            }
            if (r.sourceStart < e.getBeginB()) {
                d = e.getBeginB() - r.sourceStart;
                if (r.length <= d) {
                    Region next = r.next;
                    r.sourceStart = e.getBeginA() - d;
                    aTail = FileCandidate.add(aTail, a, r);
                    r = next;
                    continue;
                }
                aTail = FileCandidate.add(aTail, a, r.splitFirst(e.getBeginA() - d, d));
                r.slideAndShrink(d);
            }
            if (e.getLengthB() == 0) {
                ++eIdx;
                continue;
            }
            int rEnd = r.sourceStart + r.length;
            if (rEnd <= e.getEndB()) {
                Region next = r.next;
                bTail = FileCandidate.add(bTail, b, r);
                r = next;
                if (rEnd != e.getEndB()) continue;
                ++eIdx;
                continue;
            }
            int len = e.getEndB() - r.sourceStart;
            bTail = FileCandidate.add(bTail, b, r.splitFirst(r.sourceStart, len));
            r.slideAndShrink(len);
            ++eIdx;
        }
        if (r == null) {
            return;
        }
        Edit e = (Edit)editList.get(editList.size() - 1);
        int endB = e.getEndB();
        d = endB - e.getEndA();
        if (aTail == null) {
            a.regionList = r;
        } else {
            aTail.next = r;
        }
        do {
            if (endB > r.sourceStart) continue;
            r.sourceStart -= d;
        } while ((r = r.next) != null);
    }

    private static Region add(@Nullable Region aTail, FileCandidate a, Region n) {
        if (aTail == null) {
            a.regionList = n;
            n.next = null;
            return n;
        }
        if (aTail.resultStart + aTail.length == n.resultStart && aTail.sourceStart + aTail.length == n.sourceStart) {
            aTail.length += n.length;
            return aTail;
        }
        aTail.next = n;
        n.next = null;
        return n;
    }

    private Region clearRegionList() {
        Region r = this.regionList;
        this.regionList = null;
        return r;
    }

    void mergeRegions(FileCandidate other) {
        Region n;
        Region a = this.clearRegionList();
        Region b = other.clearRegionList();
        Region t = null;
        while (a != null && b != null) {
            if (a.resultStart < b.resultStart) {
                n = a.next;
                t = FileCandidate.add(t, this, a);
                a = n;
                continue;
            }
            n = b.next;
            t = FileCandidate.add(t, this, b);
            b = n;
        }
        if (a != null) {
            n = a.next;
            t = FileCandidate.add(t, this, a);
            t.next = n;
        } else if (b != null) {
            n = b.next;
            t = FileCandidate.add(t, this, b);
            t.next = n;
        }
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Candidate[");
        r.append("source path: " + this.sourcePath);
        r.append(", original path: " + this.originalPath);
        if (this.regionList != null) {
            r.append(", regions:").append(this.regionList);
        }
        r.append("]");
        return r.toString();
    }
}

