/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.sonar.scm.git.blame.BlameResult;
import org.sonar.scm.git.blame.BlameThreadFactory;
import org.sonar.scm.git.blame.BlobReader;
import org.sonar.scm.git.blame.CommitGraphNode;
import org.sonar.scm.git.blame.FileCandidate;
import org.sonar.scm.git.blame.FileTreeComparator;
import org.sonar.scm.git.blame.GraphNode;
import org.sonar.scm.git.blame.Region;
import org.sonar.scm.git.blame.SameThreadExecutorService;

public class FileBlamer {
    static final int NB_FILES_THRESHOLD_ONE_TREE_WALK = 50;
    private final ExecutorService executor;
    private final BlobReader fileReader;
    private final DiffAlgorithm diffAlgorithm;
    private final RawTextComparator textComparator;
    private final BlameResult blameResult;
    private final FileTreeComparator fileTreeComparator;
    private ObjectReader objectReader;

    public FileBlamer(FileTreeComparator fileTreeComparator, DiffAlgorithm diffAlgorithm, RawTextComparator rawTextComparator, BlobReader fileReader, BlameResult blameResult, boolean multithreading) {
        this.diffAlgorithm = diffAlgorithm;
        this.textComparator = rawTextComparator;
        this.fileReader = fileReader;
        this.blameResult = blameResult;
        this.fileTreeComparator = fileTreeComparator;
        this.executor = multithreading ? Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new BlameThreadFactory()) : SameThreadExecutorService.INSTANCE;
    }

    public void initialize(ObjectReader objectReader, GraphNode commit) {
        this.objectReader = objectReader;
        if (commit.getAllFiles().size() < 50) {
            this.initializeForSmallFileSet(objectReader, commit);
        } else {
            this.initializeForLargeFileSet(objectReader, commit);
        }
    }

    private void initializeForSmallFileSet(ObjectReader objectReader, GraphNode commit) {
        for (FileCandidate fileCandidate : commit.getAllFiles()) {
            RawText rawText = this.fileReader.loadText(objectReader, fileCandidate);
            fileCandidate.setRegionList(new Region(0, 0, rawText.size()));
            this.blameResult.initialize(fileCandidate.getPath(), rawText.size());
        }
        this.fileTreeComparator.initialize(objectReader);
    }

    private void initializeForLargeFileSet(ObjectReader objectReader, GraphNode commit) {
        Set<String> filesToCheck = commit.getAllFiles().stream().map(FileCandidate::getPath).collect(Collectors.toSet());
        try {
            Map<String, Integer> fileSizes = this.fileReader.getFileSizes(filesToCheck);
            for (FileCandidate fileCandidate : commit.getAllFiles()) {
                Integer fileSize = fileSizes.get(fileCandidate.getPath());
                if (fileSize == null) {
                    throw new IllegalStateException("Failed to find file in the working directory: " + fileCandidate.getPath());
                }
                fileCandidate.setRegionList(new Region(0, 0, fileSize));
                this.blameResult.initialize(fileCandidate.getPath(), fileSize);
            }
            this.fileTreeComparator.initialize(objectReader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void saveBlameDataForFilesInCommit(GraphNode source2) {
        RevCommit commit = source2.getCommit();
        String commitHash = commit != null ? commit.getName() : null;
        String authorEmail = commit != null ? commit.getAuthorIdent().getEmailAddress() : null;
        Instant commitDate = commit != null ? commit.getCommitterIdent().getWhenAsInstant() : null;
        for (FileCandidate sourceFile : source2.getAllFiles()) {
            if (sourceFile.getRegionList() == null) continue;
            this.blameResult.saveBlameDataForFile(commitHash, commitDate, authorEmail, sourceFile);
        }
    }

    public GraphNode blameParent(RevCommit parentCommit, GraphNode child) throws IOException {
        List<FileTreeComparator.DiffFile> diffFiles = this.fileTreeComparator.findMovedFiles(parentCommit, child.getCommit(), child.getAllPaths());
        CommitGraphNode parent = new CommitGraphNode(parentCommit, child.getAllFiles().size());
        this.blameWithFileDiffs(parent, child, diffFiles);
        return parent;
    }

    public List<GraphNode> blameParents(List<RevCommit> parentCommits, GraphNode child) throws IOException {
        int i2;
        Objects.requireNonNull(child.getCommit());
        ArrayList<List<FileTreeComparator.DiffFile>> fileTreeDiffs = new ArrayList<List<FileTreeComparator.DiffFile>>(parentCommits.size());
        ArrayList<GraphNode> parentStatefulCommits = new ArrayList<GraphNode>(parentCommits.size());
        for (RevCommit parentCommit : parentCommits) {
            CommitGraphNode parentStatefulCommit = new CommitGraphNode(parentCommit, child.getAllFiles().size());
            parentStatefulCommits.add(parentStatefulCommit);
            fileTreeDiffs.add(this.fileTreeComparator.findMovedFiles(parentCommit, child.getCommit(), child.getAllPaths()));
        }
        for (i2 = 0; i2 < parentCommits.size(); ++i2) {
            Set diffNewPaths = ((List)fileTreeDiffs.get(i2)).stream().map(FileTreeComparator.DiffFile::getNewPath).collect(Collectors.toSet());
            for (FileCandidate f : child.getAllFiles()) {
                if (diffNewPaths.contains(f.getPath())) continue;
                FileBlamer.moveFileToParent((GraphNode)parentStatefulCommits.get(i2), f, f.getPath());
            }
        }
        for (i2 = 0; i2 < parentCommits.size(); ++i2) {
            for (FileTreeComparator.DiffFile diffFile : (List)fileTreeDiffs.get(i2)) {
                Collection<FileCandidate> fileCandidates = child.getFilesByPath(diffFile.getNewPath());
                for (FileCandidate f : fileCandidates) {
                    if (!f.getBlob().equals(diffFile.getOldObjectId())) continue;
                    FileBlamer.moveFileToParent((GraphNode)parentStatefulCommits.get(i2), f, diffFile.getOldPath());
                }
            }
        }
        for (i2 = 0; i2 < parentStatefulCommits.size(); ++i2) {
            this.blameWithFileDiffs((GraphNode)parentStatefulCommits.get(i2), child, (List)fileTreeDiffs.get(i2));
        }
        return parentStatefulCommits;
    }

    public void close() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private void blameWithFileDiffs(GraphNode parent, GraphNode child, List<FileTreeComparator.DiffFile> diffFiles) {
        HashSet<String> processedFilePaths = new HashSet<String>();
        ArrayList<Future<FileCandidate>> tasks = new ArrayList<Future<FileCandidate>>();
        for (FileTreeComparator.DiffFile file : diffFiles) {
            processedFilePaths.add(file.getNewPath());
            if (file.getOldPath() == null) continue;
            child.getFilesByPath(file.getNewPath()).forEach(modifiedFile -> tasks.add(this.executor.submit(() -> this.splitBlameWithParent(file.getOldPath(), file.getOldObjectId(), (FileCandidate)modifiedFile))));
        }
        for (FileCandidate f : child.getAllFiles()) {
            if (processedFilePaths.contains(f.getPath())) continue;
            FileBlamer.moveFileToParent(parent, f, f.getPath());
        }
        FileBlamer.waitForTasks(parent, tasks);
    }

    private static void moveFileToParent(GraphNode parent, FileCandidate childFile, @Nullable String parentPath) {
        if (childFile.getRegionList() != null && parentPath != null) {
            FileCandidate parentFile = new FileCandidate(childFile.getOriginalPath(), parentPath, childFile.getBlob(), childFile.getRegionList());
            parent.addFile(parentFile);
            childFile.setRegionList(null);
        }
    }

    private static void waitForTasks(GraphNode statefulParent, Collection<Future<FileCandidate>> tasks) {
        try {
            for (Future<FileCandidate> f : tasks) {
                FileCandidate parent = f.get();
                if (parent == null) continue;
                statefulParent.addFile(parent);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @CheckForNull
    private FileCandidate splitBlameWithParent(String parentPath, ObjectId parentObjectId, FileCandidate source2) {
        if (source2.getRegionList() == null) {
            return null;
        }
        FileCandidate parent = new FileCandidate(source2.getOriginalPath(), parentPath, parentObjectId);
        if (parent.getBlob().equals(source2.getBlob())) {
            FileBlamer.moveUnmodifiedFileRegionsToParent(parent, source2);
            return parent;
        }
        ObjectReader reader = this.objectReader.newReader();
        EditList editList = this.diffAlgorithm.diff(this.textComparator, this.fileReader.loadText(reader, parent), this.fileReader.loadText(reader, source2));
        if (editList.isEmpty()) {
            FileBlamer.moveUnmodifiedFileRegionsToParent(parent, source2);
            return parent;
        }
        parent.takeBlame(editList, source2);
        return parent.getRegionList() != null ? parent : null;
    }

    private static void moveUnmodifiedFileRegionsToParent(FileCandidate parent, FileCandidate child) {
        parent.setRegionList(child.getRegionList());
        child.setRegionList(null);
    }
}

