/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git.blame;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.sonar.scm.git.blame.FileCandidate;

public class BlobReader {
    private final Repository repository;
    private final UnaryOperator<String> fileContentProvider;

    public BlobReader(Repository repository) {
        this(repository, null);
    }

    public BlobReader(Repository repository, @Nullable UnaryOperator<String> fileContentProvider) {
        this.repository = repository;
        this.fileContentProvider = fileContentProvider;
    }

    public RawText loadText(ObjectReader objectReader, FileCandidate fc) {
        try {
            if (ObjectId.zeroId().equals(fc.getBlob())) {
                return this.loadText(fc.getOriginalPath());
            }
            return BlobReader.loadText(objectReader, fc.getBlob());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private RawText loadText(String path) throws IOException {
        try (TreeWalk treeWalk = new TreeWalk(this.repository);){
            AbstractTreeIterator iter;
            this.prepareTreeWalk(treeWalk);
            treeWalk.setFilter(PathFilter.create(path));
            if (treeWalk.next() && ((iter = treeWalk.getTree(0, AbstractTreeIterator.class)).getEntryRawMode() & 0xF000) == 32768) {
                RawText rawText = this.loadText(path, treeWalk, iter);
                return rawText;
            }
        }
        throw new IllegalStateException("Failed to find file in the working directory: " + path);
    }

    private void prepareTreeWalk(TreeWalk treeWalk) throws IOException {
        treeWalk.setRecursive(true);
        if (this.repository.isBare()) {
            try (RevWalk revWalk = new RevWalk(this.repository);){
                ObjectId headId = this.repository.resolve("HEAD");
                RevCommit commit = revWalk.parseCommit(headId);
                treeWalk.addTree(commit.getTree().getId());
            }
        } else {
            treeWalk.addTree(new FileTreeIterator(this.repository));
        }
    }

    private RawText loadText(String path, TreeWalk treeWalk, AbstractTreeIterator iter) throws IOException {
        return Optional.ofNullable(this.fileContentProvider).map(fcp -> (String)fcp.apply(path)).map(fileContent -> new RawText(fileContent.getBytes(StandardCharsets.UTF_8))).orElse(this.loadTextFromRepo(treeWalk, iter));
    }

    private RawText loadTextFromRepo(TreeWalk treeWalk, AbstractTreeIterator iter) throws IOException {
        if (this.repository.isBare()) {
            ObjectLoader loader = this.repository.open(treeWalk.getObjectId(0));
            return new RawText(loader.getBytes());
        }
        return BlobReader.loadTextFromFile((FileTreeIterator)iter);
    }

    private static RawText loadText(ObjectReader objectReader, ObjectId objectId) throws IOException {
        ObjectLoader open = objectReader.open(objectId, 3);
        return new RawText(open.getCachedBytes(Integer.MAX_VALUE));
    }

    private static RawText loadTextFromFile(FileTreeIterator iter) throws IOException {
        try (InputStream is = iter.openEntryStream();){
            RawText rawText = new RawText(is.readAllBytes());
            return rawText;
        }
    }

    Map<String, Integer> getFileSizes(Set<String> files) throws IOException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try (TreeWalk treeWalk = new TreeWalk(this.repository);){
            this.prepareTreeWalk(treeWalk);
            while (treeWalk.next()) {
                AbstractTreeIterator iter = treeWalk.getTree(0, AbstractTreeIterator.class);
                if (!files.contains(iter.getEntryPathString()) || (iter.getEntryRawMode() & 0xF000) != 32768) continue;
                RawText rawText = this.loadTextFromRepo(treeWalk, iter);
                result.put(iter.getEntryPathString(), rawText.size());
            }
        }
        return result;
    }
}

