/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.sonar.scm.git.GitScmProvider;

public class JGitUtils {
    private JGitUtils() {
    }

    public static Repository buildRepository(Path basedir) {
        Object repo = GitScmProvider.getVerifiedRepositoryBuilder(basedir).build();
        ObjectReader objReader = ((Repository)repo).getObjectDatabase().newReader();
        try {
            objReader.getShallowCommits();
            Object r = repo;
            if (objReader != null) {
                objReader.close();
            }
            return r;
        }
        catch (Throwable throwable) {
            try {
                if (objReader != null) {
                    try {
                        objReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to open Git repository", e);
            }
        }
    }

    public static List<String> getAllIgnoredPaths(Path baseDir) {
        try (Repository repo = JGitUtils.buildRepository(baseDir);){
            Path workTreePath = repo.getWorkTree().toPath();
            Path baseDirAbs = baseDir.toAbsolutePath().normalize();
            Git git = new Git(repo);
            try {
                List<String> list = git.status().call().getIgnoredNotInIndex().stream().map(filePathStr -> workTreePath.resolve((String)filePathStr).normalize()).filter(filePath -> filePath.startsWith(baseDirAbs)).map(baseDir::relativize).map(Path::toString).sorted().toList();
                git.close();
                return list;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        git.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (GitAPIException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

