/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.scm.BlameLine;

public class JGitBlameCommand {
    private static final Logger LOG = LoggerFactory.getLogger(JGitBlameCommand.class);

    public List<BlameLine> blame(Git git, String filename) {
        BlameResult blameResult;
        try {
            blameResult = git.blame().setTextComparator(RawTextComparator.WS_IGNORE_ALL).setFilePath(filename).call();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to blame file " + filename, e);
        }
        ArrayList<BlameLine> lines = new ArrayList<BlameLine>();
        if (blameResult == null) {
            LOG.debug("Unable to blame file {}. It is probably a symlink.", (Object)filename);
            return Collections.emptyList();
        }
        for (int i2 = 0; i2 < blameResult.getResultContents().size(); ++i2) {
            if (blameResult.getSourceAuthor(i2) == null || blameResult.getSourceCommit(i2) == null) {
                LOG.debug("Unable to blame file {}. No blame info at line {}. Is file committed? [Author: {} Source commit: {}]", filename, i2 + 1, blameResult.getSourceAuthor(i2), blameResult.getSourceCommit(i2));
                return Collections.emptyList();
            }
            lines.add(new BlameLine().date(blameResult.getSourceCommitter(i2).getWhen()).revision(blameResult.getSourceCommit(i2).getName()).author(blameResult.getSourceAuthor(i2).getEmailAddress()));
        }
        return lines;
    }
}

