/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Startable;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.repository.TelemetryCache;
import org.sonar.scm.git.JGitUtils;

public class GitRemoteUrlProvider
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(GitRemoteUrlProvider.class);
    private static final String TELEMETRY_KEY = "scanner.git_remote_url";
    private static final String UNDETECTED = "UNDETECTED";
    private final TelemetryCache telemetryCache;
    private final InputModuleHierarchy moduleHierarchy;

    public GitRemoteUrlProvider(TelemetryCache telemetryCache, InputModuleHierarchy moduleHierarchy) {
        this.telemetryCache = telemetryCache;
        this.moduleHierarchy = moduleHierarchy;
    }

    @Override
    public void start() {
        String remoteUrl = this.getOriginRemoteUrl();
        String sanitizedUrl = this.sanitizeUrl(remoteUrl);
        this.telemetryCache.put(TELEMETRY_KEY, sanitizedUrl);
        LOG.debug("Git remote origin URL telemetry: {}", (Object)sanitizedUrl);
    }

    @Override
    public void stop() {
    }

    private String getOriginRemoteUrl() {
        Path baseDir = this.moduleHierarchy.root().getBaseDir();
        Repository repo = JGitUtils.buildRepository(baseDir);
        try {
            StoredConfig config = repo.getConfig();
            String url = config.getString("remote", "origin", "url");
            String string = Objects.requireNonNullElse(url, UNDETECTED);
            if (repo != null) {
                repo.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        repo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.debug("Unable to get git remote origin URL", e);
                return UNDETECTED;
            }
        }
    }

    String sanitizeUrl(String url) {
        if (UNDETECTED.equals(url)) {
            return url;
        }
        try {
            URI uri = new URI(url);
            if (uri.getUserInfo() != null) {
                return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
            }
            return url;
        }
        catch (URISyntaxException e) {
            return url;
        }
    }
}

