/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scm.git;

import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.fs.internal.DefaultInputFile;

@Immutable
public class ChangedFile {
    private final Path absoluteFilePath;
    private final String oldRelativeFilePathReference;

    private ChangedFile(Path absoluteFilePath, @Nullable String oldRelativeFilePathReference) {
        this.absoluteFilePath = absoluteFilePath;
        this.oldRelativeFilePathReference = oldRelativeFilePathReference;
    }

    public Path getAbsolutFilePath() {
        return this.absoluteFilePath;
    }

    @CheckForNull
    public String getOldRelativeFilePathReference() {
        return this.oldRelativeFilePathReference;
    }

    public boolean isMovedFile() {
        return this.getOldRelativeFilePathReference() != null;
    }

    public static ChangedFile of(Path path) {
        return new ChangedFile(path, null);
    }

    public static ChangedFile of(Path path, @Nullable String oldRelativeFilePathReference) {
        return new ChangedFile(path, oldRelativeFilePathReference);
    }

    public static ChangedFile of(DefaultInputFile file) {
        return new ChangedFile(file.path(), file.oldRelativePath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedFile that = (ChangedFile)o;
        return Objects.equals(this.oldRelativeFilePathReference, that.oldRelativeFilePathReference) && Objects.equals(this.absoluteFilePath, that.absoluteFilePath);
    }

    public int hashCode() {
        return Objects.hash(this.oldRelativeFilePathReference, this.absoluteFilePath);
    }
}

