/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.utils.Preconditions;

public class SensorId {
    private final String sensorName;
    @Nullable
    private final String pluginKey;

    public SensorId(@Nullable String pluginKey, String sensorName) {
        Preconditions.checkNotNull(sensorName);
        this.pluginKey = pluginKey;
        this.sensorName = sensorName;
    }

    @Nullable
    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public String toString() {
        if (this.pluginKey == null) {
            return this.sensorName;
        }
        return this.sensorName + " [" + this.pluginKey + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SensorId sensorId = (SensorId)o;
        return Objects.equals(this.sensorName, sensorId.sensorName) && Objects.equals(this.pluginKey, sensorId.pluginKey);
    }

    public int hashCode() {
        return Objects.hash(this.sensorName, this.pluginKey);
    }
}

