/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.internal.DefaultSensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.scanner.config.DefaultConfiguration;

public abstract class AbstractSensorOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSensorOptimizer.class);
    private final FileSystem fs;
    private final ActiveRules activeRules;
    private final Configuration originalConfiguration;
    private final ConfigurationReadsInterceptor config;

    public AbstractSensorOptimizer(FileSystem fs, ActiveRules activeRules, Configuration config) {
        this.fs = fs;
        this.activeRules = activeRules;
        this.originalConfiguration = config;
        this.config = new ConfigurationReadsInterceptor(config);
    }

    public boolean shouldExecute(DefaultSensorDescriptor descriptor) {
        if (!this.fsCondition(descriptor)) {
            LOG.debug("'{}' skipped because there is no related file in current project", (Object)descriptor.name());
            return false;
        }
        if (!this.activeRulesCondition(descriptor)) {
            LOG.debug("'{}' skipped because there is no related rule activated in the quality profile", (Object)descriptor.name());
            return false;
        }
        if (!this.settingsCondition(descriptor)) {
            String accessedConfiguration = this.config.getAccessedKeys().stream().map(key -> "- " + key + ": " + this.getConfigurationValue((String)key).orElse("<empty>")).collect(Collectors.joining("\n"));
            LOG.debug("'{}' skipped because of missing configuration requirements.\nAccessed configuration:\n{}", (Object)descriptor.name(), (Object)accessedConfiguration);
            return false;
        }
        return true;
    }

    private Optional<String> getConfigurationValue(String key) {
        Configuration configuration = this.originalConfiguration;
        if (configuration instanceof DefaultConfiguration) {
            DefaultConfiguration configuration2 = (DefaultConfiguration)configuration;
            return Optional.ofNullable(configuration2.getOriginalProperties().get(key));
        }
        return this.config.get(key);
    }

    private boolean settingsCondition(DefaultSensorDescriptor descriptor) {
        if (descriptor.configurationPredicate() != null) {
            return descriptor.configurationPredicate().test(this.config);
        }
        return true;
    }

    private boolean activeRulesCondition(DefaultSensorDescriptor descriptor) {
        if (!descriptor.ruleRepositories().isEmpty()) {
            for (String repoKey : descriptor.ruleRepositories()) {
                if (this.activeRules.findByRepository(repoKey).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean fsCondition(DefaultSensorDescriptor descriptor) {
        if (!descriptor.languages().isEmpty() || descriptor.type() != null) {
            FilePredicate langPredicate = descriptor.languages().isEmpty() ? this.fs.predicates().all() : this.fs.predicates().hasLanguages(descriptor.languages());
            FilePredicate typePredicate = descriptor.type() == null ? this.fs.predicates().all() : this.fs.predicates().hasType(descriptor.type());
            return this.fs.hasFiles(this.fs.predicates().and(langPredicate, typePredicate));
        }
        return true;
    }

    private static class ConfigurationReadsInterceptor
    implements Configuration {
        private final Configuration configuration;
        private final Set<String> accessedKeys;

        private ConfigurationReadsInterceptor(Configuration configuration) {
            this.configuration = configuration;
            this.accessedKeys = new HashSet<String>();
        }

        Set<String> getAccessedKeys() {
            return this.accessedKeys;
        }

        @Override
        public boolean hasKey(String key) {
            boolean hasKey = this.configuration.hasKey(key);
            this.accessedKeys.add(key);
            return hasKey;
        }

        @Override
        public Optional<String> get(String key) {
            Optional<String> value = this.configuration.get(key);
            this.accessedKeys.add(key);
            return value;
        }

        @Override
        public String[] getStringArray(String key) {
            String[] values2 = this.configuration.getStringArray(key);
            this.accessedKeys.add(key);
            return values2;
        }
    }
}

