/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.impl.utils.ScannerUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scm.ScmChangedFiles;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scm.git.ChangedFile;
import org.sonar.scm.git.GitScmProvider;
import org.springframework.context.annotation.Bean;

public class ScmChangedFilesProvider {
    private static final Logger LOG = Loggers.get(ScmChangedFilesProvider.class);
    private static final String LOG_MSG = "SCM collecting changed files in the branch";

    @Bean(value={"ScmChangedFiles"})
    public ScmChangedFiles provide(ScmConfiguration scmConfiguration, BranchConfiguration branchConfiguration, DefaultInputProject project) {
        Path rootBaseDir = project.getBaseDir();
        Set<ChangedFile> changedFiles = ScmChangedFilesProvider.loadChangedFilesIfNeeded(scmConfiguration, branchConfiguration, rootBaseDir);
        if (changedFiles != null) {
            ScmChangedFilesProvider.validatePaths(ScmChangedFilesProvider.getAbsoluteFilePaths(changedFiles));
        }
        return new ScmChangedFiles(changedFiles);
    }

    private static void validatePaths(Set<Path> changedFilePaths) {
        if (changedFilePaths.stream().anyMatch(p -> !p.isAbsolute())) {
            throw new IllegalStateException("SCM provider returned a changed file with a relative path but paths must be absolute. Please fix the provider.");
        }
    }

    private static Set<Path> getAbsoluteFilePaths(Collection<ChangedFile> changedFiles) {
        return changedFiles.stream().map(ChangedFile::getAbsolutFilePath).collect(Collectors.toSet());
    }

    @CheckForNull
    private static Set<ChangedFile> loadChangedFilesIfNeeded(ScmConfiguration scmConfiguration, BranchConfiguration branchConfiguration, Path rootBaseDir) {
        String targetBranchName = branchConfiguration.targetBranchName();
        if (branchConfiguration.isPullRequest() && targetBranchName != null) {
            ScmProvider scmProvider = scmConfiguration.provider();
            if (scmProvider != null) {
                Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
                Set<ChangedFile> changedFiles = ScmChangedFilesProvider.getChangedFilesByScm(scmProvider, targetBranchName, rootBaseDir);
                profiler.stopInfo();
                if (changedFiles != null) {
                    LOG.debug("SCM reported {} {} changed in the branch", (Object)changedFiles.size(), (Object)ScannerUtils.pluralize("file", changedFiles.size()));
                    return changedFiles;
                }
            }
            LOG.debug("SCM information about changed files in the branch is not available");
        }
        return null;
    }

    private static Set<ChangedFile> getChangedFilesByScm(ScmProvider scmProvider, String targetBranchName, Path rootBaseDir) {
        if (scmProvider instanceof GitScmProvider) {
            GitScmProvider gitScmProvider = (GitScmProvider)scmProvider;
            return gitScmProvider.branchChangedFilesWithFileMovementDetection(targetBranchName, rootBaseDir);
        }
        return ScmChangedFilesProvider.toChangedFiles(scmProvider.branchChangedFiles(targetBranchName, rootBaseDir));
    }

    @CheckForNull
    private static Set<ChangedFile> toChangedFiles(@Nullable Set<Path> changedPaths) {
        if (changedPaths == null) {
            return null;
        }
        return changedPaths.stream().map(ChangedFile::of).collect(Collectors.toSet());
    }
}

