/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.scm.ScmChangedFiles;

@Immutable
public class StatusDetection {
    private final ProjectRepositories projectRepositories;
    private final ScmChangedFiles scmChangedFiles;

    public StatusDetection(ProjectRepositories projectRepositories, ScmChangedFiles scmChangedFiles) {
        this.projectRepositories = projectRepositories;
        this.scmChangedFiles = scmChangedFiles;
    }

    public boolean isScmStatusAvailable() {
        return this.scmChangedFiles.isValid();
    }

    InputFile.Status status(String moduleKeyWithBranch, DefaultInputFile inputFile, String hash) {
        InputFile.Status statusFromScm = this.findStatusFromScm(inputFile);
        if (statusFromScm != null) {
            return statusFromScm;
        }
        return this.checkChangedWithProjectRepositories(moduleKeyWithBranch, inputFile, hash);
    }

    InputFile.Status findStatusFromScm(DefaultInputFile inputFile) {
        if (this.isScmStatusAvailable()) {
            return this.checkChangedWithScm(inputFile);
        }
        return null;
    }

    private InputFile.Status checkChangedWithProjectRepositories(String moduleKeyWithBranch, DefaultInputFile inputFile, String hash) {
        FileData fileDataPerPath = this.projectRepositories.fileData(moduleKeyWithBranch, inputFile);
        if (fileDataPerPath == null) {
            return InputFile.Status.ADDED;
        }
        String previousHash = fileDataPerPath.hash();
        if (Strings.CS.equals(hash, previousHash)) {
            return InputFile.Status.SAME;
        }
        if (StringUtils.isEmpty(previousHash)) {
            return InputFile.Status.ADDED;
        }
        return InputFile.Status.CHANGED;
    }

    private InputFile.Status checkChangedWithScm(DefaultInputFile inputFile) {
        if (!this.scmChangedFiles.isChanged(inputFile.path())) {
            return InputFile.Status.SAME;
        }
        return InputFile.Status.CHANGED;
    }
}

