/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractProjectOrModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.scm.IgnoreCommand;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.bootstrap.GlobalServerSettings;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.scan.ModuleConfiguration;
import org.sonar.scanner.scan.ModuleConfigurationProvider;
import org.sonar.scanner.scan.ProjectServerSettings;
import org.sonar.scanner.scan.SonarGlobalPropertiesFilter;
import org.sonar.scanner.scan.filesystem.DirectoryFileVisitor;
import org.sonar.scanner.scan.filesystem.FilePreprocessor;
import org.sonar.scanner.scan.filesystem.HiddenFilesProjectData;
import org.sonar.scanner.scan.filesystem.LanguageDetection;
import org.sonar.scanner.scan.filesystem.ModuleExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectExclusionFilters;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scanner.util.ProgressReport;

public class ProjectFilePreprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectFilePreprocessor.class);
    private final AnalysisWarnings analysisWarnings;
    private final IgnoreCommand ignoreCommand;
    private final boolean useScmExclusion;
    private final ScmConfiguration scmConfiguration;
    private final InputModuleHierarchy inputModuleHierarchy;
    private final GlobalConfiguration globalConfig;
    private final GlobalServerSettings globalServerSettings;
    private final ProjectServerSettings projectServerSettings;
    private final LanguageDetection languageDetection;
    private final FilePreprocessor filePreprocessor;
    private final ProjectExclusionFilters projectExclusionFilters;
    private final HiddenFilesProjectData hiddenFilesProjectData;
    private final SonarGlobalPropertiesFilter sonarGlobalPropertiesFilter;
    private final Map<DefaultInputModule, List<Path>> mainSourcesByModule = new HashMap<DefaultInputModule, List<Path>>();
    private final Map<DefaultInputModule, List<Path>> testSourcesByModule = new HashMap<DefaultInputModule, List<Path>>();
    private final ProgressReport progressReport = new ProgressReport("Report about progress of file preprocessing", TimeUnit.SECONDS.toMillis(10L));
    private int totalFilesPreprocessed = 0;

    public ProjectFilePreprocessor(AnalysisWarnings analysisWarnings, ScmConfiguration scmConfiguration, InputModuleHierarchy inputModuleHierarchy, GlobalConfiguration globalConfig, GlobalServerSettings globalServerSettings, ProjectServerSettings projectServerSettings, LanguageDetection languageDetection, FilePreprocessor filePreprocessor, ProjectExclusionFilters projectExclusionFilters, SonarGlobalPropertiesFilter sonarGlobalPropertiesFilter, HiddenFilesProjectData hiddenFilesProjectData) {
        this.analysisWarnings = analysisWarnings;
        this.scmConfiguration = scmConfiguration;
        this.inputModuleHierarchy = inputModuleHierarchy;
        this.globalConfig = globalConfig;
        this.globalServerSettings = globalServerSettings;
        this.projectServerSettings = projectServerSettings;
        this.languageDetection = languageDetection;
        this.filePreprocessor = filePreprocessor;
        this.projectExclusionFilters = projectExclusionFilters;
        this.sonarGlobalPropertiesFilter = sonarGlobalPropertiesFilter;
        this.ignoreCommand = this.loadIgnoreCommand();
        this.useScmExclusion = this.ignoreCommand != null;
        this.hiddenFilesProjectData = hiddenFilesProjectData;
    }

    public void execute() {
        this.progressReport.start("Preprocessing files...");
        this.progressReport.message(() -> String.format("Preprocessed %s files", this.totalFilesPreprocessed));
        ExclusionCounter exclusionCounter = new ExclusionCounter();
        if (this.useScmExclusion) {
            this.ignoreCommand.init(this.inputModuleHierarchy.root().getBaseDir().toAbsolutePath());
            this.processModulesRecursively(this.inputModuleHierarchy.root(), exclusionCounter);
            this.ignoreCommand.clean();
        } else {
            this.processModulesRecursively(this.inputModuleHierarchy.root(), exclusionCounter);
        }
        int totalLanguagesDetected = this.languageDetection.getDetectedLanguages().size();
        this.progressReport.stopAndLogTotalTime(String.format("%s detected in %s", ProjectFilePreprocessor.pluralizeWithCount("language", totalLanguagesDetected), ProjectFilePreprocessor.pluralizeWithCount("preprocessed file", this.totalFilesPreprocessed)));
        int excludedFileByPatternCount = exclusionCounter.getByPatternsCount();
        if ((this.projectExclusionFilters.hasPattern() || excludedFileByPatternCount > 0) && LOG.isInfoEnabled()) {
            LOG.info("{} ignored because of inclusion/exclusion patterns", (Object)ProjectFilePreprocessor.pluralizeWithCount("file", excludedFileByPatternCount));
        }
        int excludedFileByScmCount = exclusionCounter.getByScmCount();
        if (this.useScmExclusion && LOG.isInfoEnabled()) {
            LOG.info("{} ignored because of scm ignore settings", (Object)ProjectFilePreprocessor.pluralizeWithCount("file", excludedFileByScmCount));
        }
    }

    private void processModulesRecursively(DefaultInputModule module, ExclusionCounter exclusionCounter) {
        this.inputModuleHierarchy.children(module).stream().sorted(Comparator.comparing(AbstractProjectOrModule::key)).forEach(m -> this.processModulesRecursively((DefaultInputModule)m, exclusionCounter));
        this.processModule(module, exclusionCounter);
    }

    private void processModule(DefaultInputModule module, ExclusionCounter exclusionCounter) {
        ModuleConfiguration moduleConfig = new ModuleConfigurationProvider(this.sonarGlobalPropertiesFilter).provide(this.globalConfig, module, this.globalServerSettings, this.projectServerSettings);
        ModuleExclusionFilters moduleExclusionFilters = new ModuleExclusionFilters(moduleConfig, this.analysisWarnings);
        boolean hasChildModules = !module.definition().getSubProjects().isEmpty();
        boolean hasTests = module.getTestDirsOrFiles().isPresent();
        List mainSourceDirsOrFiles = module.getSourceDirsOrFiles().orElseGet(() -> hasChildModules || hasTests ? Collections.emptyList() : Collections.singletonList(module.getBaseDir().toAbsolutePath()));
        List<Path> processedSources = this.processModuleSources(module, moduleConfig, moduleExclusionFilters, mainSourceDirsOrFiles, InputFile.Type.MAIN, exclusionCounter);
        this.mainSourcesByModule.put(module, processedSources);
        this.totalFilesPreprocessed += processedSources.size();
        module.getTestDirsOrFiles().ifPresent(tests -> {
            List<Path> processedTestSources = this.processModuleSources(module, moduleConfig, moduleExclusionFilters, (List<Path>)tests, InputFile.Type.TEST, exclusionCounter);
            this.testSourcesByModule.put(module, processedTestSources);
            this.totalFilesPreprocessed += processedTestSources.size();
        });
    }

    private List<Path> processModuleSources(DefaultInputModule module, ModuleConfiguration moduleConfiguration, ModuleExclusionFilters moduleExclusionFilters, List<Path> sources, InputFile.Type type, ExclusionCounter exclusionCounter) {
        ArrayList<Path> processedFiles = new ArrayList<Path>();
        try {
            for (Path dirOrFile : sources) {
                if (dirOrFile.toFile().isDirectory()) {
                    processedFiles.addAll(this.processDirectory(module, moduleConfiguration, moduleExclusionFilters, dirOrFile, type, exclusionCounter));
                    continue;
                }
                this.filePreprocessor.processFile(module, moduleExclusionFilters, dirOrFile, type, exclusionCounter, this.ignoreCommand).ifPresentOrElse(processedFiles::add, () -> this.hiddenFilesProjectData.getIsMarkedAsHiddenFileAndRemoveVisibilityInformation(dirOrFile, module));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to preprocess files", e);
        }
        return processedFiles;
    }

    private List<Path> processDirectory(DefaultInputModule module, ModuleConfiguration moduleConfiguration, ModuleExclusionFilters moduleExclusionFilters, Path path, InputFile.Type type, ExclusionCounter exclusionCounter) throws IOException {
        ArrayList<Path> processedFiles = new ArrayList<Path>();
        Files.walkFileTree(path.normalize(), Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new DirectoryFileVisitor(file -> this.filePreprocessor.processFile(module, moduleExclusionFilters, file, type, exclusionCounter, this.ignoreCommand).ifPresentOrElse(processedFiles::add, () -> this.removeVisibilityInformationIfNotProcessed(module, file, type)), module, moduleConfiguration, moduleExclusionFilters, this.inputModuleHierarchy, type, this.hiddenFilesProjectData));
        return processedFiles;
    }

    private void removeVisibilityInformationIfNotProcessed(DefaultInputModule module, Path file, InputFile.Type type) {
        List<Path> processedSources;
        boolean processedByMainSources = false;
        if (type == InputFile.Type.TEST && (processedSources = this.mainSourcesByModule.get(module)) != null) {
            processedByMainSources = processedSources.contains(file);
        }
        if (!processedByMainSources) {
            this.hiddenFilesProjectData.getIsMarkedAsHiddenFileAndRemoveVisibilityInformation(file, module);
        }
    }

    public List<Path> getMainSourcesByModule(DefaultInputModule module) {
        return Collections.unmodifiableList(this.mainSourcesByModule.get(module));
    }

    public Optional<List<Path>> getTestSourcesByModule(DefaultInputModule module) {
        return Optional.ofNullable(this.testSourcesByModule.get(module)).map(Collections::unmodifiableList);
    }

    private IgnoreCommand loadIgnoreCommand() {
        try {
            ScmProvider provider = this.scmConfiguration.provider();
            if (!this.scmConfiguration.isExclusionDisabled() && provider != null) {
                return provider.ignoreCommand();
            }
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("File exclusion based on SCM ignore information is not available with this plugin.");
        }
        return null;
    }

    private static String pluralizeWithCount(String str, int count) {
        Object pluralized = count == 1 ? str : str + "s";
        return count + " " + (String)pluralized;
    }

    public static class ExclusionCounter {
        private int excludedByPatternsCount = 0;
        private int excludedByScmCount = 0;

        public void increaseByPatternsCount() {
            ++this.excludedByPatternsCount;
        }

        public int getByPatternsCount() {
            return this.excludedByPatternsCount;
        }

        public void increaseByScmCount() {
            ++this.excludedByScmCount;
        }

        public int getByScmCount() {
            return this.excludedByScmCount;
        }
    }
}

