/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractProjectOrModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.bootstrap.GlobalServerSettings;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.scan.ModuleConfiguration;
import org.sonar.scanner.scan.ModuleConfigurationProvider;
import org.sonar.scanner.scan.ProjectServerSettings;
import org.sonar.scanner.scan.SonarGlobalPropertiesFilter;
import org.sonar.scanner.scan.filesystem.DirectoryFileVisitor;
import org.sonar.scanner.scan.filesystem.FileIndexer;
import org.sonar.scanner.scan.filesystem.HiddenFilesProjectData;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.filesystem.ModuleCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ModuleExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ProjectExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectFilePreprocessor;
import org.sonar.scanner.util.ProgressReport;

public class ProjectFileIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectFileIndexer.class);
    private final ProjectExclusionFilters projectExclusionFilters;
    private final SonarGlobalPropertiesFilter sonarGlobalPropertiesFilter;
    private final ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions;
    private final InputComponentStore componentStore;
    private final InputModuleHierarchy inputModuleHierarchy;
    private final GlobalConfiguration globalConfig;
    private final GlobalServerSettings globalServerSettings;
    private final ProjectServerSettings projectServerSettings;
    private final FileIndexer fileIndexer;
    private final ProjectFilePreprocessor projectFilePreprocessor;
    private final AnalysisWarnings analysisWarnings;
    private final HiddenFilesProjectData hiddenFilesProjectData;
    private ProgressReport progressReport;

    public ProjectFileIndexer(InputComponentStore componentStore, ProjectExclusionFilters exclusionFilters, SonarGlobalPropertiesFilter sonarGlobalPropertiesFilter, InputModuleHierarchy inputModuleHierarchy, GlobalConfiguration globalConfig, GlobalServerSettings globalServerSettings, ProjectServerSettings projectServerSettings, FileIndexer fileIndexer, ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions, ProjectFilePreprocessor projectFilePreprocessor, AnalysisWarnings analysisWarnings, HiddenFilesProjectData hiddenFilesProjectData) {
        this.componentStore = componentStore;
        this.sonarGlobalPropertiesFilter = sonarGlobalPropertiesFilter;
        this.inputModuleHierarchy = inputModuleHierarchy;
        this.globalConfig = globalConfig;
        this.globalServerSettings = globalServerSettings;
        this.projectServerSettings = projectServerSettings;
        this.fileIndexer = fileIndexer;
        this.projectExclusionFilters = exclusionFilters;
        this.projectCoverageAndDuplicationExclusions = projectCoverageAndDuplicationExclusions;
        this.projectFilePreprocessor = projectFilePreprocessor;
        this.analysisWarnings = analysisWarnings;
        this.hiddenFilesProjectData = hiddenFilesProjectData;
    }

    public void index() {
        this.progressReport = new ProgressReport("Report about progress of file indexing", TimeUnit.SECONDS.toMillis(10L));
        this.progressReport.start("Indexing files...");
        LOG.info("Project configuration:");
        this.projectExclusionFilters.log("  ");
        this.projectCoverageAndDuplicationExclusions.log("  ");
        this.indexModulesRecursively(this.inputModuleHierarchy.root());
        this.hiddenFilesProjectData.clearHiddenFilesData();
        int totalIndexed = this.componentStore.inputFiles().size();
        this.progressReport.stopAndLogTotalTime(totalIndexed + " " + ProjectFileIndexer.pluralizeFiles(totalIndexed) + " indexed");
    }

    private void indexModulesRecursively(DefaultInputModule module) {
        this.inputModuleHierarchy.children(module).stream().sorted(Comparator.comparing(AbstractProjectOrModule::key)).forEach(this::indexModulesRecursively);
        this.index(module);
    }

    private void index(DefaultInputModule module) {
        ModuleConfiguration moduleConfig = new ModuleConfigurationProvider(this.sonarGlobalPropertiesFilter).provide(this.globalConfig, module, this.globalServerSettings, this.projectServerSettings);
        ModuleExclusionFilters moduleExclusionFilters = new ModuleExclusionFilters(moduleConfig, this.analysisWarnings);
        ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions = new ModuleCoverageAndDuplicationExclusions(moduleConfig);
        if (this.componentStore.allModules().size() > 1) {
            LOG.info("Indexing files of module '{}'", (Object)module.getName());
            LOG.info("  Base dir: {}", (Object)module.getBaseDir().toAbsolutePath());
            module.getSourceDirsOrFiles().ifPresent(srcs -> ProjectFileIndexer.logPaths("  Source paths: ", module.getBaseDir(), srcs));
            module.getTestDirsOrFiles().ifPresent(tests -> ProjectFileIndexer.logPaths("  Test paths: ", module.getBaseDir(), tests));
            moduleExclusionFilters.log("  ");
            moduleCoverageAndDuplicationExclusions.log("  ");
        }
        List<Path> mainSourceDirsOrFiles = this.projectFilePreprocessor.getMainSourcesByModule(module);
        this.indexFiles(module, moduleConfig, moduleExclusionFilters, moduleCoverageAndDuplicationExclusions, mainSourceDirsOrFiles, InputFile.Type.MAIN);
        this.projectFilePreprocessor.getTestSourcesByModule(module).ifPresent(tests -> this.indexFiles(module, moduleConfig, moduleExclusionFilters, moduleCoverageAndDuplicationExclusions, (List<Path>)tests, InputFile.Type.TEST));
    }

    private static void logPaths(String label, Path baseDir, List<Path> paths) {
        if (!paths.isEmpty()) {
            StringBuilder sb = new StringBuilder(label);
            Iterator<Path> it = paths.iterator();
            while (it.hasNext()) {
                Path file = it.next();
                Optional<String> relativePathToBaseDir = PathResolver.relativize(baseDir, file);
                if (relativePathToBaseDir.isEmpty()) {
                    sb.append(file);
                } else if (StringUtils.isBlank(relativePathToBaseDir.get())) {
                    sb.append(".");
                } else {
                    sb.append(relativePathToBaseDir.get());
                }
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(sb.toString());
            } else {
                LOG.info(StringUtils.abbreviate(sb.toString(), 80));
            }
        }
    }

    private void indexFiles(DefaultInputModule module, ModuleConfiguration moduleConfig, ModuleExclusionFilters moduleExclusionFilters, ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, List<Path> sources, InputFile.Type type) {
        try {
            for (Path dirOrFile : sources) {
                if (dirOrFile.toFile().isDirectory()) {
                    this.indexDirectory(module, moduleConfig, moduleExclusionFilters, moduleCoverageAndDuplicationExclusions, dirOrFile, type);
                    continue;
                }
                this.fileIndexer.indexFile(module, moduleCoverageAndDuplicationExclusions, dirOrFile, type, this.progressReport);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to index files", e);
        }
    }

    private void indexDirectory(DefaultInputModule module, ModuleConfiguration moduleConfig, ModuleExclusionFilters moduleExclusionFilters, ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, Path dirToIndex, InputFile.Type type) throws IOException {
        Files.walkFileTree(dirToIndex.normalize(), Collections.singleton(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new DirectoryFileVisitor(file -> this.fileIndexer.indexFile(module, moduleCoverageAndDuplicationExclusions, file, type, this.progressReport), module, moduleConfig, moduleExclusionFilters, this.inputModuleHierarchy, type, this.hiddenFilesProjectData));
    }

    private static String pluralizeFiles(int count) {
        return count == 1 ? "file" : "files";
    }
}

