/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.file.Path;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.predicates.ChangedFilePredicate;
import org.sonar.api.batch.fs.internal.predicates.NonHiddenFilesPredicate;

public class MutableFileSystem
extends DefaultFileSystem {
    boolean restrictToChangedFiles = false;
    boolean allowHiddenFileAnalysis = false;

    public MutableFileSystem(Path baseDir, DefaultFileSystem.Cache cache, FilePredicates filePredicates) {
        super(baseDir, cache, filePredicates);
    }

    MutableFileSystem(Path baseDir) {
        super(baseDir);
    }

    @Override
    public Iterable<InputFile> inputFiles(FilePredicate requestPredicate) {
        return super.inputFiles(this.applyAdditionalPredicate(requestPredicate));
    }

    @Override
    public InputFile inputFile(FilePredicate requestPredicate) {
        return super.inputFile(this.applyAdditionalPredicate(requestPredicate));
    }

    private FilePredicate applyAdditionalPredicate(FilePredicate requestPredicate) {
        return this.applyHiddenFilePredicate(this.applyChangedFilePredicate(requestPredicate));
    }

    private FilePredicate applyHiddenFilePredicate(FilePredicate predicate) {
        if (this.allowHiddenFileAnalysis) {
            return predicate;
        }
        return this.predicates().and((FilePredicate)new NonHiddenFilesPredicate(), predicate);
    }

    private FilePredicate applyChangedFilePredicate(FilePredicate predicate) {
        if (this.restrictToChangedFiles) {
            return this.predicates().and((FilePredicate)new ChangedFilePredicate(), predicate);
        }
        return predicate;
    }

    public void setRestrictToChangedFiles(boolean restrictToChangedFiles) {
        this.restrictToChangedFiles = restrictToChangedFiles;
    }

    public void setAllowHiddenFileAnalysis(boolean allowHiddenFileAnalysis) {
        this.allowHiddenFileAnalysis = allowHiddenFileAnalysis;
    }
}

