/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.notifications.AnalysisWarnings;

public class ModuleRelativePathWarner {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleRelativePathWarner.class);
    private final AnalysisWarnings analysisWarnings;
    private final Set<String> previouslyWarnedProps = new HashSet<String>();

    public ModuleRelativePathWarner(AnalysisWarnings analysisWarnings) {
        this.analysisWarnings = analysisWarnings;
    }

    public void warnOnce(String propKey, String filePath) {
        if (!this.previouslyWarnedProps.contains(propKey)) {
            this.previouslyWarnedProps.add(propKey);
            String msg = "Specifying module-relative paths at project level in the property '" + propKey + "' is deprecated. To continue matching files like '" + filePath + "', update this property so that patterns refer to project-relative paths.";
            LOG.warn(msg);
            this.analysisWarnings.addUnique(msg);
        }
    }
}

