/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

@ScannerSide
public class ModuleInputComponentStore
extends DefaultFileSystem.Cache {
    private final String moduleKey;
    private final InputComponentStore inputComponentStore;
    private final SensorStrategy strategy;

    public ModuleInputComponentStore(InputModule module, InputComponentStore inputComponentStore, SensorStrategy strategy) {
        this.moduleKey = module.key();
        this.inputComponentStore = inputComponentStore;
        this.strategy = strategy;
    }

    @Override
    public Iterable<InputFile> inputFiles() {
        if (this.strategy.isGlobal()) {
            return this.inputComponentStore.inputFiles();
        }
        return this.inputComponentStore.filesByModule(this.moduleKey);
    }

    @Override
    public InputFile inputFile(String relativePath) {
        if (this.strategy.isGlobal()) {
            return this.inputComponentStore.inputFile(relativePath);
        }
        return this.inputComponentStore.getFile(this.moduleKey, relativePath);
    }

    @Override
    public SortedSet<String> languages() {
        if (this.strategy.isGlobal()) {
            return this.inputComponentStore.languages();
        }
        return this.inputComponentStore.languages(this.moduleKey);
    }

    @Override
    protected void doAdd(InputFile inputFile) {
        this.inputComponentStore.put(this.moduleKey, inputFile);
    }

    @Override
    public Iterable<InputFile> getFilesByName(String filename) {
        Iterable<InputFile> allFilesByName = this.inputComponentStore.getFilesByName(filename);
        if (this.strategy.isGlobal()) {
            return allFilesByName;
        }
        return this.filterByModule(allFilesByName);
    }

    @Override
    public Iterable<InputFile> getFilesByExtension(String extension) {
        Iterable<InputFile> allFilesByExtension = this.inputComponentStore.getFilesByExtension(extension);
        if (this.strategy.isGlobal()) {
            return allFilesByExtension;
        }
        return this.filterByModule(allFilesByExtension);
    }

    private Iterable<InputFile> filterByModule(Iterable<InputFile> projectInputFiles) {
        Set projectInputFilesSet = StreamSupport.stream(projectInputFiles.spliterator(), false).collect(Collectors.toSet());
        return StreamSupport.stream(this.inputComponentStore.filesByModule(this.moduleKey).spliterator(), false).filter(projectInputFilesSet::contains).toList();
    }
}

