/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributes;
import org.apache.commons.lang3.SystemUtils;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.scanner.scan.ModuleConfiguration;
import org.sonar.scanner.scan.filesystem.HiddenFilesProjectData;

public class HiddenFilesVisitorHelper {
    private static final String EXCLUDE_HIDDEN_FILES_PROPERTY = "sonar.scanner.excludeHiddenFiles";
    private final HiddenFilesProjectData hiddenFilesProjectData;
    private final DefaultInputModule module;
    final boolean excludeHiddenFiles;
    private Path moduleWorkDir;
    Path rootHiddenDir;

    public HiddenFilesVisitorHelper(HiddenFilesProjectData hiddenFilesProjectData, DefaultInputModule module, ModuleConfiguration moduleConfig) {
        this.hiddenFilesProjectData = hiddenFilesProjectData;
        this.module = module;
        this.excludeHiddenFiles = moduleConfig.getBoolean(EXCLUDE_HIDDEN_FILES_PROPERTY).orElse(false);
    }

    public boolean shouldVisitDir(Path path) throws IOException {
        boolean isHidden = HiddenFilesVisitorHelper.isHiddenDir(path);
        if (isHidden && (this.excludeHiddenFiles || this.isExcludedHiddenDirectory(path))) {
            return false;
        }
        if (isHidden) {
            this.enterHiddenDirectory(path);
        }
        return true;
    }

    private boolean isExcludedHiddenDirectory(Path path) throws IOException {
        return this.getCachedModuleWorkDir().equals(path) || this.hiddenFilesProjectData.getCachedSonarUserHomePath().equals(path);
    }

    void enterHiddenDirectory(Path dir) {
        if (!this.insideHiddenDirectory()) {
            this.rootHiddenDir = dir;
        }
    }

    public void exitDirectory(Path path) {
        if (this.insideHiddenDirectory() && this.rootHiddenDir.equals(path)) {
            this.resetRootHiddenDir();
        }
    }

    void resetRootHiddenDir() {
        this.rootHiddenDir = null;
    }

    public boolean shouldVisitFile(Path path) throws IOException {
        boolean isHidden;
        boolean bl = isHidden = this.insideHiddenDirectory() || Files.isHidden(path);
        if (!this.excludeHiddenFiles && isHidden) {
            this.hiddenFilesProjectData.markAsHiddenFile(path, this.module);
        }
        return !this.excludeHiddenFiles || !isHidden;
    }

    private Path getCachedModuleWorkDir() throws IOException {
        if (this.moduleWorkDir == null) {
            this.moduleWorkDir = this.hiddenFilesProjectData.resolveRealPath(this.module.getWorkDir());
        }
        return this.moduleWorkDir;
    }

    boolean insideHiddenDirectory() {
        return this.rootHiddenDir != null;
    }

    protected static boolean isHiddenDir(Path path) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                DosFileAttributes dosFileAttributes = Files.readAttributes(path, DosFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                return dosFileAttributes.isHidden();
            }
            catch (UnsupportedOperationException e) {
                return path.toFile().isHidden();
            }
        }
        return Files.isHidden(path);
    }
}

