/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.scanner.bootstrap.SonarUserHome;

public class HiddenFilesProjectData {
    final Map<DefaultInputModule, Set<Path>> hiddenFilesByModule = new HashMap<DefaultInputModule, Set<Path>>();
    private final SonarUserHome sonarUserHome;
    private Path cachedSonarUserHomePath;

    public HiddenFilesProjectData(SonarUserHome sonarUserHome) {
        this.sonarUserHome = sonarUserHome;
    }

    public void markAsHiddenFile(Path file, DefaultInputModule module) {
        this.hiddenFilesByModule.computeIfAbsent(module, k -> new HashSet()).add(file);
    }

    public boolean getIsMarkedAsHiddenFileAndRemoveVisibilityInformation(Path file, DefaultInputModule module) {
        Set<Path> hiddenFilesPerModule = this.hiddenFilesByModule.get(module);
        if (hiddenFilesPerModule != null) {
            return hiddenFilesPerModule.remove(file);
        }
        return false;
    }

    public Path getCachedSonarUserHomePath() throws IOException {
        if (this.cachedSonarUserHomePath == null) {
            this.cachedSonarUserHomePath = this.resolveRealPath(this.sonarUserHome.getPath());
        }
        return this.cachedSonarUserHomePath;
    }

    public void clearHiddenFilesData() {
        this.hiddenFilesByModule.clear();
    }

    public Path resolveRealPath(Path path) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return path.toRealPath(LinkOption.NOFOLLOW_LINKS).toAbsolutePath().normalize();
        }
        return path;
    }
}

