/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.scm.IgnoreCommand;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.scan.filesystem.LanguageDetection;
import org.sonar.scanner.scan.filesystem.ModuleExclusionFilters;
import org.sonar.scanner.scan.filesystem.ModuleRelativePathWarner;
import org.sonar.scanner.scan.filesystem.ProjectExclusionFilters;
import org.sonar.scanner.scan.filesystem.ProjectFilePreprocessor;

public class FilePreprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(FilePreprocessor.class);
    private final ModuleRelativePathWarner moduleRelativePathWarner;
    private final DefaultInputProject project;
    private final LanguageDetection languageDetection;
    private final ProjectExclusionFilters projectExclusionFilters;
    private final ScanProperties properties;

    public FilePreprocessor(ModuleRelativePathWarner moduleRelativePathWarner, DefaultInputProject project, LanguageDetection languageDetection, ProjectExclusionFilters projectExclusionFilters, ScanProperties properties) {
        this.moduleRelativePathWarner = moduleRelativePathWarner;
        this.project = project;
        this.languageDetection = languageDetection;
        this.projectExclusionFilters = projectExclusionFilters;
        this.properties = properties;
    }

    public Optional<Path> processFile(DefaultInputModule module, ModuleExclusionFilters moduleExclusionFilters, Path sourceFile, InputFile.Type type, ProjectFilePreprocessor.ExclusionCounter exclusionCounter, @CheckForNull IgnoreCommand ignoreCommand) throws IOException {
        Path moduleRelativePath;
        Path realAbsoluteFile = sourceFile.toRealPath(LinkOption.NOFOLLOW_LINKS).toAbsolutePath().normalize();
        if (!this.isValidSymbolicLink(realAbsoluteFile, module.getBaseDir())) {
            return Optional.empty();
        }
        Path projectRelativePath = this.project.getBaseDir().relativize(realAbsoluteFile);
        boolean included = this.isFileIncluded(moduleExclusionFilters, realAbsoluteFile, projectRelativePath, moduleRelativePath = module.getBaseDir().relativize(realAbsoluteFile), type);
        if (!included) {
            exclusionCounter.increaseByPatternsCount();
            return Optional.empty();
        }
        boolean excluded = this.isFileExcluded(moduleExclusionFilters, realAbsoluteFile, projectRelativePath, moduleRelativePath, type);
        if (excluded) {
            exclusionCounter.increaseByPatternsCount();
            return Optional.empty();
        }
        if (!realAbsoluteFile.startsWith(this.project.getBaseDir())) {
            LOG.warn("File '{}' is ignored. It is not located in project basedir '{}'.", (Object)realAbsoluteFile.toAbsolutePath(), (Object)this.project.getBaseDir());
            return Optional.empty();
        }
        if (!realAbsoluteFile.startsWith(module.getBaseDir())) {
            LOG.warn("File '{}' is ignored. It is not located in module basedir '{}'.", (Object)realAbsoluteFile.toAbsolutePath(), (Object)module.getBaseDir());
            return Optional.empty();
        }
        if (ignoreCommand != null && ignoreCommand.isIgnored(realAbsoluteFile)) {
            LOG.debug("File '{}' is excluded by the scm ignore settings.", (Object)realAbsoluteFile);
            exclusionCounter.increaseByScmCount();
            return Optional.empty();
        }
        if (Files.exists(realAbsoluteFile, new LinkOption[0]) && this.isFileSizeBiggerThanLimit(realAbsoluteFile)) {
            LOG.warn("File '{}' is bigger than {}MB and as consequence is removed from the analysis scope.", (Object)realAbsoluteFile.toAbsolutePath(), (Object)this.properties.fileSizeLimit());
            return Optional.empty();
        }
        this.languageDetection.language(realAbsoluteFile, projectRelativePath);
        return Optional.of(realAbsoluteFile);
    }

    private boolean isFileIncluded(ModuleExclusionFilters moduleExclusionFilters, Path realAbsoluteFile, Path projectRelativePath, Path moduleRelativePath, InputFile.Type type) {
        if (!Arrays.equals(moduleExclusionFilters.getInclusionsConfig(type), this.projectExclusionFilters.getInclusionsConfig(type))) {
            return moduleExclusionFilters.isIncluded(realAbsoluteFile, moduleRelativePath, type);
        }
        boolean includedByProjectConfiguration = this.projectExclusionFilters.isIncluded(realAbsoluteFile, projectRelativePath, type);
        if (includedByProjectConfiguration) {
            return true;
        }
        if (moduleExclusionFilters.isIncluded(realAbsoluteFile, moduleRelativePath, type)) {
            this.moduleRelativePathWarner.warnOnce(type == InputFile.Type.MAIN ? "sonar.inclusions" : "sonar.test.inclusions", FilenameUtils.normalize(projectRelativePath.toString(), true));
            return true;
        }
        return false;
    }

    private boolean isFileExcluded(ModuleExclusionFilters moduleExclusionFilters, Path realAbsoluteFile, Path projectRelativePath, Path moduleRelativePath, InputFile.Type type) {
        if (!Arrays.equals(moduleExclusionFilters.getExclusionsConfig(type), this.projectExclusionFilters.getExclusionsConfig(type))) {
            return moduleExclusionFilters.isExcluded(realAbsoluteFile, moduleRelativePath, type);
        }
        boolean includedByProjectConfiguration = this.projectExclusionFilters.isExcluded(realAbsoluteFile, projectRelativePath, type);
        if (includedByProjectConfiguration) {
            return true;
        }
        if (moduleExclusionFilters.isExcluded(realAbsoluteFile, moduleRelativePath, type)) {
            this.moduleRelativePathWarner.warnOnce(type == InputFile.Type.MAIN ? "sonar.exclusions" : "sonar.test.exclusions", FilenameUtils.normalize(projectRelativePath.toString(), true));
            return true;
        }
        return false;
    }

    private boolean isFileSizeBiggerThanLimit(Path filePath) throws IOException {
        return Files.size(filePath) > this.properties.fileSizeLimit() * 1024L * 1024L;
    }

    private boolean isValidSymbolicLink(Path absolutePath, Path moduleBaseDirectory) throws IOException {
        if (!Files.isSymbolicLink(absolutePath)) {
            return true;
        }
        Optional<Path> target = FilePreprocessor.resolvePathToTarget(absolutePath);
        if (target.isEmpty() || !Files.exists(target.get(), new LinkOption[0])) {
            LOG.warn("File '{}' is ignored. It is a symbolic link targeting a file that does not exist.", (Object)absolutePath);
            return false;
        }
        if (!target.get().startsWith(this.project.getBaseDir())) {
            LOG.warn("File '{}' is ignored. It is a symbolic link targeting a file not located in project basedir.", (Object)absolutePath);
            return false;
        }
        if (!target.get().startsWith(moduleBaseDirectory)) {
            LOG.info("File '{}' is ignored. It is a symbolic link targeting a file not located in module basedir.", (Object)absolutePath);
            return false;
        }
        return true;
    }

    private static Optional<Path> resolvePathToTarget(Path symbolicLinkAbsolutePath) throws IOException {
        Path target = Files.readSymbolicLink(symbolicLinkAbsolutePath);
        if (target.isAbsolute()) {
            return Optional.of(target);
        }
        try {
            return Optional.of(symbolicLinkAbsolutePath.getParent().resolve(target).toRealPath(LinkOption.NOFOLLOW_LINKS).toAbsolutePath().normalize());
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

