/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.file.Path;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.resources.Languages;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.repository.language.Language;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.scan.filesystem.HiddenFilesProjectData;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.scan.filesystem.InputFileFilterRepository;
import org.sonar.scanner.scan.filesystem.LanguageDetection;
import org.sonar.scanner.scan.filesystem.MetadataGenerator;
import org.sonar.scanner.scan.filesystem.ModuleCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ModuleRelativePathWarner;
import org.sonar.scanner.scan.filesystem.ProjectCoverageAndDuplicationExclusions;
import org.sonar.scanner.scan.filesystem.ScannerComponentIdGenerator;
import org.sonar.scanner.scan.filesystem.StatusDetection;
import org.sonar.scanner.scm.ScmChangedFiles;
import org.sonar.scanner.util.ProgressReport;

public class FileIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(FileIndexer.class);
    private final ScanProperties properties;
    private final ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions;
    private final IssueExclusionsLoader issueExclusionsLoader;
    private final MetadataGenerator metadataGenerator;
    private final DefaultInputProject project;
    private final ScannerComponentIdGenerator scannerComponentIdGenerator;
    private final InputComponentStore componentStore;
    private final SensorStrategy sensorStrategy;
    private final LanguageDetection langDetection;
    private final StatusDetection statusDetection;
    private final ScmChangedFiles scmChangedFiles;
    private final ModuleRelativePathWarner moduleRelativePathWarner;
    private final InputFileFilterRepository inputFileFilterRepository;
    private final Languages languages;
    private final HiddenFilesProjectData hiddenFilesProjectData;

    public FileIndexer(DefaultInputProject project, ScannerComponentIdGenerator scannerComponentIdGenerator, InputComponentStore componentStore, ProjectCoverageAndDuplicationExclusions projectCoverageAndDuplicationExclusions, IssueExclusionsLoader issueExclusionsLoader, MetadataGenerator metadataGenerator, SensorStrategy sensorStrategy, LanguageDetection languageDetection, ScanProperties properties, ScmChangedFiles scmChangedFiles, StatusDetection statusDetection, ModuleRelativePathWarner moduleRelativePathWarner, InputFileFilterRepository inputFileFilterRepository, Languages languages, HiddenFilesProjectData hiddenFilesProjectData) {
        this.project = project;
        this.scannerComponentIdGenerator = scannerComponentIdGenerator;
        this.componentStore = componentStore;
        this.projectCoverageAndDuplicationExclusions = projectCoverageAndDuplicationExclusions;
        this.issueExclusionsLoader = issueExclusionsLoader;
        this.metadataGenerator = metadataGenerator;
        this.sensorStrategy = sensorStrategy;
        this.langDetection = languageDetection;
        this.properties = properties;
        this.scmChangedFiles = scmChangedFiles;
        this.statusDetection = statusDetection;
        this.moduleRelativePathWarner = moduleRelativePathWarner;
        this.inputFileFilterRepository = inputFileFilterRepository;
        this.languages = languages;
        this.hiddenFilesProjectData = hiddenFilesProjectData;
    }

    void indexFile(DefaultInputModule module, ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, Path sourceFile, InputFile.Type type, ProgressReport progressReport) {
        Path projectRelativePath = this.project.getBaseDir().relativize(sourceFile);
        Path moduleRelativePath = module.getBaseDir().relativize(sourceFile);
        Language language = this.langDetection.language(sourceFile, projectRelativePath);
        boolean isHidden = this.hiddenFilesProjectData.getIsMarkedAsHiddenFileAndRemoveVisibilityInformation(sourceFile, module);
        DefaultIndexedFile indexedFile = new DefaultIndexedFile(sourceFile, this.project.key(), projectRelativePath.toString(), moduleRelativePath.toString(), type, language != null ? language.key() : null, this.scannerComponentIdGenerator.getAsInt(), this.sensorStrategy, this.scmChangedFiles.getOldRelativeFilePath(sourceFile), isHidden);
        DefaultInputFile inputFile = new DefaultInputFile(indexedFile, f -> this.metadataGenerator.setMetadata(module.key(), (DefaultInputFile)f, module.getEncoding()), f -> f.setStatus(this.statusDetection.findStatusFromScm((DefaultInputFile)f)));
        if (!isHidden && language != null && this.isPublishAllFiles(language.key())) {
            inputFile.setPublished(true);
        }
        if (!this.accept(inputFile)) {
            return;
        }
        this.checkIfAlreadyIndexed(inputFile);
        this.componentStore.put(module.key(), inputFile);
        this.issueExclusionsLoader.addMulticriteriaPatterns(inputFile);
        String langStr = inputFile.language() != null ? String.format("with language '%s'", inputFile.language()) : "with no language";
        LOG.debug("'{}' indexed {}{}", inputFile, type == InputFile.Type.TEST ? "as test " : "", langStr);
        this.evaluateCoverageExclusions(moduleCoverageAndDuplicationExclusions, inputFile);
        this.evaluateDuplicationExclusions(moduleCoverageAndDuplicationExclusions, inputFile);
        if (this.properties.preloadFileMetadata()) {
            inputFile.checkMetadata();
        }
        int count = this.componentStore.inputFiles().size();
        progressReport.message(count + " " + FileIndexer.pluralizeFiles(count) + " indexed...  (last one was " + inputFile.getProjectRelativePath() + ")");
    }

    private boolean isPublishAllFiles(String languageKey) {
        if (this.languages.get(languageKey) != null) {
            return this.languages.get(languageKey).publishAllFiles();
        }
        return false;
    }

    private void checkIfAlreadyIndexed(DefaultInputFile inputFile) {
        if (this.componentStore.inputFile(inputFile.getProjectRelativePath()) != null) {
            throw MessageException.of("File " + String.valueOf(inputFile) + " can't be indexed twice. Please check that inclusion/exclusion patterns produce disjoint sets for main and test files");
        }
    }

    private void evaluateCoverageExclusions(ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, DefaultInputFile inputFile) {
        boolean excludedForCoverage = this.isExcludedForCoverage(moduleCoverageAndDuplicationExclusions, inputFile);
        inputFile.setExcludedForCoverage(excludedForCoverage);
        if (excludedForCoverage) {
            LOG.debug("File {} excluded for coverage", (Object)inputFile);
        }
    }

    private boolean isExcludedForCoverage(ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, DefaultInputFile inputFile) {
        if (!Arrays.equals(moduleCoverageAndDuplicationExclusions.getCoverageExclusionConfig(), this.projectCoverageAndDuplicationExclusions.getCoverageExclusionConfig())) {
            return moduleCoverageAndDuplicationExclusions.isExcludedForCoverage(inputFile);
        }
        boolean excludedByProjectConfiguration = this.projectCoverageAndDuplicationExclusions.isExcludedForCoverage(inputFile);
        if (excludedByProjectConfiguration) {
            return true;
        }
        if (moduleCoverageAndDuplicationExclusions.isExcludedForCoverage(inputFile)) {
            this.moduleRelativePathWarner.warnOnce("sonar.coverage.exclusions", inputFile.getProjectRelativePath());
            return true;
        }
        return false;
    }

    private void evaluateDuplicationExclusions(ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, DefaultInputFile inputFile) {
        boolean excludedForDuplications = this.isExcludedForDuplications(moduleCoverageAndDuplicationExclusions, inputFile);
        inputFile.setExcludedForDuplication(excludedForDuplications);
        if (excludedForDuplications) {
            LOG.debug("File {} excluded for duplication", (Object)inputFile);
        }
    }

    private boolean isExcludedForDuplications(ModuleCoverageAndDuplicationExclusions moduleCoverageAndDuplicationExclusions, DefaultInputFile inputFile) {
        if (!Arrays.equals(moduleCoverageAndDuplicationExclusions.getDuplicationExclusionConfig(), this.projectCoverageAndDuplicationExclusions.getDuplicationExclusionConfig())) {
            return moduleCoverageAndDuplicationExclusions.isExcludedForDuplication(inputFile);
        }
        boolean excludedByProjectConfiguration = this.projectCoverageAndDuplicationExclusions.isExcludedForDuplication(inputFile);
        if (excludedByProjectConfiguration) {
            return true;
        }
        if (moduleCoverageAndDuplicationExclusions.isExcludedForDuplication(inputFile)) {
            this.moduleRelativePathWarner.warnOnce("sonar.cpd.exclusions", inputFile.getProjectRelativePath());
            return true;
        }
        return false;
    }

    private boolean accept(InputFile indexedFile) {
        for (InputFileFilter filter : this.inputFileFilterRepository.getInputFileFilters()) {
            if (filter.accept(indexedFile)) continue;
            LOG.debug("'{}' excluded by {}", (Object)indexedFile, (Object)filter.getClass().getName());
            return false;
        }
        return true;
    }

    private static String pluralizeFiles(int count) {
        return count == 1 ? "file" : "files";
    }
}

