/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.scan.ModuleConfiguration;
import org.sonar.scanner.scan.filesystem.HiddenFilesProjectData;
import org.sonar.scanner.scan.filesystem.HiddenFilesVisitorHelper;
import org.sonar.scanner.scan.filesystem.ModuleExclusionFilters;

public class DirectoryFileVisitor
implements FileVisitor<Path> {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryFileVisitor.class);
    private final FileVisitAction fileVisitAction;
    private final DefaultInputModule module;
    private final ModuleExclusionFilters moduleExclusionFilters;
    private final InputModuleHierarchy inputModuleHierarchy;
    private final InputFile.Type type;
    private final HiddenFilesVisitorHelper hiddenFilesVisitorHelper;

    DirectoryFileVisitor(FileVisitAction fileVisitAction, DefaultInputModule module, ModuleConfiguration moduleConfig, ModuleExclusionFilters moduleExclusionFilters, InputModuleHierarchy inputModuleHierarchy, InputFile.Type type, HiddenFilesProjectData hiddenFilesProjectData) {
        this.fileVisitAction = fileVisitAction;
        this.module = module;
        this.moduleExclusionFilters = moduleExclusionFilters;
        this.inputModuleHierarchy = inputModuleHierarchy;
        this.type = type;
        this.hiddenFilesVisitorHelper = new HiddenFilesVisitorHelper(hiddenFilesProjectData, module, moduleConfig);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.hiddenFilesVisitorHelper.shouldVisitDir(dir)) {
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.hiddenFilesVisitorHelper.shouldVisitFile(file)) {
            this.fileVisitAction.execute(file);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc instanceof FileSystemLoopException) {
            LOG.warn("Not indexing due to symlink loop: {}", (Object)file.toFile());
            return FileVisitResult.CONTINUE;
        }
        if (exc instanceof AccessDeniedException && this.isExcluded(file)) {
            return FileVisitResult.CONTINUE;
        }
        throw exc;
    }

    private boolean isExcluded(Path path) throws IOException {
        Path realAbsoluteFile = path.toRealPath(LinkOption.NOFOLLOW_LINKS).toAbsolutePath().normalize();
        return DirectoryFileVisitor.isExcludedDirectory(this.moduleExclusionFilters, realAbsoluteFile, this.inputModuleHierarchy.root().getBaseDir(), this.module.getBaseDir(), this.type);
    }

    private static boolean isExcludedDirectory(ModuleExclusionFilters moduleExclusionFilters, Path realAbsoluteFile, Path projectBaseDir, Path moduleBaseDir, InputFile.Type type) {
        Path projectRelativePath = projectBaseDir.relativize(realAbsoluteFile);
        Path moduleRelativePath = moduleBaseDir.relativize(realAbsoluteFile);
        return moduleExclusionFilters.isExcludedAsParentDirectoryOfExcludedChildren(realAbsoluteFile, projectRelativePath, projectBaseDir, type) || moduleExclusionFilters.isExcludedAsParentDirectoryOfExcludedChildren(realAbsoluteFile, moduleRelativePath, moduleBaseDir, type);
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        this.hiddenFilesVisitorHelper.exitDirectory(dir);
        return FileVisitResult.CONTINUE;
    }

    @FunctionalInterface
    static interface FileVisitAction {
        public void execute(Path var1) throws IOException;
    }
}

