/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class CharsetValidation {
    private static final double UTF_16_NULL_PASS_THRESHOLD = 0.7;
    private static final double UTF_16_NULL_FAIL_THRESHOLD = 0.1;
    private static final boolean[] VALID_WINDOWS_1252 = new boolean[256];

    public Result isUTF16(byte[] buffer, boolean failOnNull) {
        if (buffer.length < 2) {
            return Result.INVALID;
        }
        int beAscii = 0;
        int beLines = 0;
        int leAscii = 0;
        int leLines = 0;
        for (int i2 = 0; i2 < buffer.length / 2; ++i2) {
            byte c1 = buffer[i2 * 2];
            byte c2 = buffer[i2 * 2 + 1];
            if (c1 == 0) {
                if (c2 != 0) {
                    if (c2 == 10 || c2 == 13) {
                        ++beLines;
                    }
                    ++beAscii;
                    continue;
                }
                if (!failOnNull) continue;
                return Result.INVALID;
            }
            if (c2 != 0) continue;
            ++leAscii;
            if (c1 != 10 && c1 != 13) continue;
            ++leLines;
        }
        double beAsciiPerc = (double)beAscii * 2.0 / (double)buffer.length;
        double leAsciiPerc = (double)leAscii * 2.0 / (double)buffer.length;
        if (leLines == 0) {
            if (beAsciiPerc >= 0.7 && leAsciiPerc < 0.1) {
                return Result.newValid(StandardCharsets.UTF_16BE);
            }
            if (beLines > 0) {
                return Result.newValid(StandardCharsets.UTF_16BE);
            }
        } else if (beLines > 0) {
            return Result.INVALID;
        }
        if (beLines == 0) {
            if (leAsciiPerc >= 0.7 && beAsciiPerc < 0.1) {
                return Result.newValid(StandardCharsets.UTF_16LE);
            }
            if (leLines > 0) {
                return Result.newValid(StandardCharsets.UTF_16LE);
            }
        }
        return new Result(Validation.MAYBE, null);
    }

    public boolean isValidUTF16(byte[] buffer) {
        return this.isValidUTF16(buffer, false);
    }

    public boolean isValidUTF16(byte[] buffer, boolean le) {
        if (buffer.length < 2) {
            return false;
        }
        for (int i2 = 0; i2 < buffer.length / 2; ++i2) {
            boolean extraByte = false;
            int c = CharsetValidation.read16bit(buffer, i2, le);
            if (c >= 55296 && c < 56320) {
                extraByte = true;
                ++i2;
            } else if (c >= 56320 && c < 57344 || c == 0) {
                return false;
            }
            if (!extraByte || i2 >= buffer.length / 2 || (c = CharsetValidation.read16bit(buffer, i2, le)) >= 56320 && c < 57344) continue;
            return false;
        }
        return true;
    }

    public Result isUTF8(byte[] buffer, boolean rejectNulls) {
        boolean onlyAscii = true;
        for (int i2 = 0; i2 < buffer.length; ++i2) {
            int len;
            int c = 0xFF & buffer[i2];
            if (rejectNulls && c == 0) {
                return Result.INVALID;
            }
            if ((c & 0x80) == 0) {
                len = 0;
            } else if (c >= 194 && c < 224) {
                len = 1;
            } else if ((c & 0xF0) == 224) {
                len = 2;
            } else if ((c & 0xF8) == 240) {
                len = 3;
            } else {
                return Result.INVALID;
            }
            while (len > 0 && ++i2 < buffer.length) {
                c = 0xFF & buffer[i2];
                onlyAscii = false;
                if ((c & 0xC0) != 128) {
                    return Result.INVALID;
                }
                len = (byte)(len - 1);
            }
        }
        return onlyAscii ? new Result(Validation.MAYBE, StandardCharsets.UTF_8) : Result.newValid(StandardCharsets.UTF_8);
    }

    public boolean tryDecode(byte[] bytes, @Nullable Charset charset) {
        if (charset == null) {
            return false;
        }
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }

    private static int read16bit(byte[] buffer, int i2, boolean le) {
        return le ? buffer[i2 / 2] & 0xFF | (buffer[i2 / 2 + 1] & 0xFF) << 8 : (buffer[i2 / 2] & 0xFF) << 8 | buffer[i2 / 2 + 1] & 0xFF;
    }

    public Result isValidWindows1252(byte[] buf) {
        for (byte b : buf) {
            if (VALID_WINDOWS_1252[b + 128]) continue;
            return Result.INVALID;
        }
        try {
            return new Result(Validation.MAYBE, Charset.forName("Windows-1252"));
        }
        catch (UnsupportedCharsetException e) {
            return Result.INVALID;
        }
    }

    static {
        Arrays.fill(VALID_WINDOWS_1252, true);
        CharsetValidation.VALID_WINDOWS_1252[1] = false;
        CharsetValidation.VALID_WINDOWS_1252[13] = false;
        CharsetValidation.VALID_WINDOWS_1252[15] = false;
        CharsetValidation.VALID_WINDOWS_1252[16] = false;
        CharsetValidation.VALID_WINDOWS_1252[29] = false;
    }

    public static class Result {
        static final Result INVALID = new Result(Validation.NO, null);
        private Validation valid;
        private Charset charset;

        public Result(Validation valid, @Nullable Charset charset) {
            this.valid = valid;
            this.charset = charset;
        }

        public static Result newValid(Charset charset) {
            return new Result(Validation.YES, charset);
        }

        public Validation valid() {
            return this.valid;
        }

        @CheckForNull
        public Charset charset() {
            return this.charset;
        }
    }

    public static enum Validation {
        NO,
        YES,
        MAYBE;

    }
}

