/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import jakarta.annotation.Priority;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.measures.Metrics;
import org.sonar.api.resources.Languages;
import org.sonar.core.config.ScannerProperties;
import org.sonar.core.language.LanguagesProvider;
import org.sonar.core.metric.ScannerMetrics;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.SpringComponentContainer;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.ExtensionMatcher;
import org.sonar.scanner.bootstrap.ExtensionUtils;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.PostJobExtensionDictionary;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.cpd.CpdExecutor;
import org.sonar.scanner.fs.InputModuleHierarchy;
import org.sonar.scanner.issue.IssueFilterExtensionDictionary;
import org.sonar.scanner.issue.IssueFilters;
import org.sonar.scanner.mediumtest.AnalysisObservers;
import org.sonar.scanner.postjob.DefaultPostJobContext;
import org.sonar.scanner.postjob.PostJobOptimizer;
import org.sonar.scanner.postjob.PostJobsExecutor;
import org.sonar.scanner.qualitygate.QualityGateCheck;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.rule.QProfileVerifier;
import org.sonar.scanner.sca.CliCacheService;
import org.sonar.scanner.sca.CliService;
import org.sonar.scanner.sca.ScaExecutor;
import org.sonar.scanner.scan.ProjectBuildersExecutor;
import org.sonar.scanner.scan.ProjectConfigurationProvider;
import org.sonar.scanner.scan.ProjectLock;
import org.sonar.scanner.scan.ScanProperties;
import org.sonar.scanner.scan.SpringModuleScanContainer;
import org.sonar.scanner.scan.filesystem.FileIndexer;
import org.sonar.scanner.scan.filesystem.InputFileFilterRepository;
import org.sonar.scanner.scan.filesystem.LanguageDetection;
import org.sonar.scanner.scan.filesystem.ProjectFileIndexer;
import org.sonar.scanner.scm.ScmPublisher;
import org.sonar.scanner.sensor.ProjectSensorContext;
import org.sonar.scanner.sensor.ProjectSensorExtensionDictionary;
import org.sonar.scanner.sensor.ProjectSensorOptimizer;
import org.sonar.scanner.sensor.ProjectSensorsExecutor;

@Priority(value=2)
public class SpringProjectScanContainer
extends SpringComponentContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringProjectScanContainer.class);

    public SpringProjectScanContainer(SpringComponentContainer parentContainer) {
        super(parentContainer);
    }

    @Override
    protected void doBeforeStart() {
        Set<String> languages = this.getParentComponentByType(LanguageDetection.class).getDetectedLanguages();
        this.installPluginsForLanguages(languages);
        this.addScannerComponents();
    }

    private void installPluginsForLanguages(Set<String> languageKeys) {
        ScannerPluginRepository pluginRepository = this.getParentComponentByType(ScannerPluginRepository.class);
        Collection<PluginInfo> languagePlugins = pluginRepository.installPluginsForLanguages(languageKeys);
        for (PluginInfo pluginInfo : languagePlugins) {
            Plugin instance = pluginRepository.getPluginInstance(pluginInfo.getKey());
            this.addExtension(pluginInfo, (Object)instance);
        }
        this.getParentComponentByType(ExtensionInstaller.class).installExtensionsForPlugins(this, SpringProjectScanContainer.getScannerProjectExtensionsFilter(), languagePlugins);
    }

    private void addScannerComponents() {
        this.add(ProjectConfigurationProvider.class, ScanProperties.class, LanguagesProvider.class, QProfileVerifier.class, ScannerProperties.class, QualityGateCheck.class, PostJobsExecutor.class, PostJobOptimizer.class, DefaultPostJobContext.class, PostJobExtensionDictionary.class, SensorStrategy.class, ProjectSensorContext.class, ProjectSensorExtensionDictionary.class, ProjectSensorsExecutor.class, ProjectSensorOptimizer.class, IssueFilterExtensionDictionary.class, AnalysisObservers.class, InputFileFilterRepository.class, FileIndexer.class, ProjectFileIndexer.class, CliService.class, CliCacheService.class, ScaExecutor.class);
    }

    static ExtensionMatcher getScannerProjectExtensionsFilter() {
        return extension -> {
            if (ExtensionUtils.isDeprecatedScannerSide(extension)) {
                return ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH");
            }
            return ExtensionUtils.isScannerSide(extension);
        };
    }

    @Override
    protected void doAfterStart() {
        this.getParentComponentByType(ScannerMetrics.class).addPluginMetrics(this.getComponentsByType(Metrics.class));
        this.getParentComponentByType(IssueFilters.class).registerFilters(this.getComponentByType(IssueFilterExtensionDictionary.class).selectIssueFilters());
        this.getComponentByType(ProjectLock.class).tryLock();
        ProjectBuilder[] phase2ProjectBuilders = this.getComponentsByType(ProjectBuilder.class).toArray(new ProjectBuilder[0]);
        this.getComponentByType(ProjectBuildersExecutor.class).executeProjectBuilders(phase2ProjectBuilders, this.getComponentByType(ProjectReactor.class), "Executing phase 2 project builders");
        this.getComponentByType(ProjectFileIndexer.class).index();
        GlobalAnalysisMode analysisMode = this.getComponentByType(GlobalAnalysisMode.class);
        InputModuleHierarchy tree = this.getComponentByType(InputModuleHierarchy.class);
        ScanProperties properties = this.getComponentByType(ScanProperties.class);
        if (this.getComponentByType(Languages.class).all().length == 0) {
            LOG.warn("No language plugins are installed.");
        }
        this.getComponentByType(QProfileVerifier.class).execute();
        this.scanRecursively(tree, tree.root());
        LOG.info("------------- Run sensors on project");
        this.getComponentByType(ProjectSensorsExecutor.class).execute();
        LOG.info("------------- Gather SCA dependencies on project");
        this.getComponentByType(ScaExecutor.class).execute(tree.root());
        this.getComponentByType(ScmPublisher.class).publish();
        this.getComponentByType(CpdExecutor.class).execute();
        this.getComponentByType(ReportPublisher.class).execute();
        if (properties.shouldWaitForQualityGate()) {
            LOG.info("------------- Check Quality Gate status");
            this.getComponentByType(QualityGateCheck.class).await();
        }
        this.getComponentByType(PostJobsExecutor.class).execute();
        if (analysisMode.isMediumTest()) {
            this.getComponentByType(AnalysisObservers.class).notifyEndOfScanTask();
        }
    }

    private void scanRecursively(InputModuleHierarchy tree, DefaultInputModule module) {
        for (DefaultInputModule child : tree.children(module)) {
            this.scanRecursively(tree, child);
        }
        LOG.info("------------- Run sensors on module {}", (Object)module.definition().getName());
        this.scan(module);
    }

    void scan(DefaultInputModule module) {
        new SpringModuleScanContainer((SpringComponentContainer)this, module).execute();
    }
}

