/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.annotations.VisibleForTesting;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SonarGlobalPropertiesFilter {
    @VisibleForTesting
    static final String SONAR_GLOBAL_PROPERTIES_PREFIX = "sonar.global.";

    public Map<String, String> enforceOnlyServerSideSonarGlobalPropertiesAreUsed(Map<String, String> settingProperties, Map<String, String> globalServerSettingsProperties) {
        Map<String, String> settings = SonarGlobalPropertiesFilter.getNonSonarGlobalProperties(settingProperties);
        settings.putAll(SonarGlobalPropertiesFilter.getSonarGlobalProperties(globalServerSettingsProperties));
        return settings;
    }

    private static Map<String, String> getNonSonarGlobalProperties(Map<String, String> settingProperties) {
        LinkedHashMap<String, String> nonSonarGlobalProperties = new LinkedHashMap<String, String>();
        settingProperties.forEach((key, value) -> {
            if (!SonarGlobalPropertiesFilter.isSonarGlobalProperty(key)) {
                nonSonarGlobalProperties.put((String)key, (String)value);
            }
        });
        return nonSonarGlobalProperties;
    }

    private static Map<String, String> getSonarGlobalProperties(Map<String, String> properties) {
        return properties.entrySet().stream().filter(entry -> SonarGlobalPropertiesFilter.isSonarGlobalProperty((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean isSonarGlobalProperty(String propertiesCode) {
        return propertiesCode.startsWith(SONAR_GLOBAL_PROPERTIES_PREFIX);
    }
}

