/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import org.sonar.api.Startable;
import org.sonar.scanner.repository.TelemetryCache;
import org.sonar.scanner.scan.ScanProperties;

public class ScanPropertiesTelemetryProvider
implements Startable {
    private static final String TELEMETRY_JRE_PROVISIONING_DISABLED = "jre_provisioning_disabled";
    private static final String PROPERTY_SCANNER_APP = "sonar.scanner.app";
    private static final String PROPERTY_SCANNER_APP_VERSION = "sonar.scanner.appVersion";
    private static final String PROPERTY_JRE_AUTO_PROVISIONING_DISABLED = "sonar.jreAutoProvisioning.disabled";
    private static final String PROPERTY_SCANNER_SKIP_JRE_PROVISIONING = "sonar.scanner.skipJreProvisioning";
    private static final String PROPERTY_SCANNER_JAVA_EXE_PATH = "sonar.scanner.javaExePath";
    private static final String UNKNOWN_VALUE = "unknown";
    private final ScanProperties scanProperties;
    private final TelemetryCache telemetryCache;

    public ScanPropertiesTelemetryProvider(ScanProperties scanProperties, TelemetryCache telemetryCache) {
        this.scanProperties = scanProperties;
        this.telemetryCache = telemetryCache;
    }

    @Override
    public void start() {
        this.telemetryCache.put(TELEMETRY_JRE_PROVISIONING_DISABLED, String.valueOf(this.isProvisioningDisabled()));
        this.telemetryCache.put(PROPERTY_SCANNER_APP, this.scanProperties.get(PROPERTY_SCANNER_APP).orElse(UNKNOWN_VALUE));
        this.telemetryCache.put(PROPERTY_SCANNER_APP_VERSION, this.scanProperties.get(PROPERTY_SCANNER_APP_VERSION).orElse(UNKNOWN_VALUE));
    }

    private boolean isProvisioningDisabled() {
        return this.scanProperties.get(PROPERTY_JRE_AUTO_PROVISIONING_DISABLED).map(Boolean::valueOf).orElse(false) != false || this.scanProperties.get(PROPERTY_SCANNER_SKIP_JRE_PROVISIONING).map(Boolean::valueOf).orElse(false) != false || this.scanProperties.get(PROPERTY_SCANNER_JAVA_EXE_PATH).isPresent();
    }

    @Override
    public void stop() {
    }
}

