/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.scanner.repository.settings.ProjectSettingsLoader;
import org.sonar.scanner.scan.ProjectServerSettings;
import org.springframework.context.annotation.Bean;

public class ProjectServerSettingsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectServerSettingsProvider.class);
    private static final String MODULE_LEVEL_ARCHIVED_SETTINGS_WARNING = "Settings that were previously configured at sub-project level are not used anymore. Transition the settings listed in \u2018General Settings -> General -> Archived Sub-Projects Settings' at project level, and clear the property to prevent the analysis from displaying this warning.";

    @Bean(value={"ProjectServerSettings"})
    public ProjectServerSettings provide(ProjectSettingsLoader loader, AnalysisWarnings analysisWarnings) {
        Map<String, String> serverSideSettings = loader.loadProjectSettings();
        if (StringUtils.isNotBlank(serverSideSettings.get("sonar.subproject.settings.archived"))) {
            LOG.warn(MODULE_LEVEL_ARCHIVED_SETTINGS_WARNING);
            analysisWarnings.addUnique(MODULE_LEVEL_ARCHIVED_SETTINGS_WARNING);
        }
        return new ProjectServerSettings(serverSideSettings);
    }
}

