/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.lang.reflect.Method;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.batch.bootstrap.internal.ProjectBuilderContext;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectBuildersExecutor {
    private static final Logger LOG = Loggers.get(ProjectBuildersExecutor.class);
    private final GlobalConfiguration globalConfig;
    private final ProjectBuilder[] projectBuilders;

    @Autowired(required=false)
    public ProjectBuildersExecutor(GlobalConfiguration globalConfig, ProjectBuilder ... projectBuilders) {
        this.globalConfig = globalConfig;
        this.projectBuilders = projectBuilders;
    }

    @Autowired(required=false)
    public ProjectBuildersExecutor(GlobalConfiguration globalConfig) {
        this(globalConfig, new ProjectBuilder[0]);
    }

    public void execute(ProjectReactor reactor) {
        this.executeProjectBuilders(this.projectBuilders, reactor, "Execute project builders");
    }

    public void executeProjectBuilders(ProjectBuilder[] projectBuilders, ProjectReactor reactor, String profilerMessage) {
        if (projectBuilders.length > 0) {
            Profiler profiler = Profiler.create(LOG).startInfo(profilerMessage);
            ProjectBuilderContext context = new ProjectBuilderContext(reactor, this.globalConfig);
            for (ProjectBuilder projectBuilder : projectBuilders) {
                try {
                    LOG.debug("Execute project builder: {}", (Object)projectBuilder.getClass().getName());
                    projectBuilder.build(context);
                }
                catch (Exception e) {
                    throw MessageException.of("Failed to execute project builder: " + ProjectBuildersExecutor.getDescription(projectBuilder), e);
                }
            }
            profiler.stopInfo();
        }
    }

    private static String getDescription(ProjectBuilder projectBuilder) {
        Method toString;
        try {
            toString = projectBuilder.getClass().getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            return projectBuilder.toString();
        }
        if (toString.getDeclaringClass() != Object.class) {
            return projectBuilder.toString();
        }
        return projectBuilder.getClass().getName();
    }
}

