/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.scanner.scan.DefaultInputModuleHierarchy;
import org.sonar.scanner.scan.WorkDirectoriesInitializer;
import org.sonar.scanner.scan.filesystem.ScannerComponentIdGenerator;
import org.springframework.context.annotation.Bean;

public class InputModuleHierarchyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(InputModuleHierarchyProvider.class);

    @Bean(value={"DefaultInputModuleHierarchy"})
    public DefaultInputModuleHierarchy provide(ScannerComponentIdGenerator scannerComponentIdGenerator, WorkDirectoriesInitializer workDirectoriesInit, DefaultInputProject project) {
        LOG.debug("Creating module hierarchy");
        DefaultInputModule root = InputModuleHierarchyProvider.createModule(project.definition(), project.scannerId());
        Map<DefaultInputModule, DefaultInputModule> parents = InputModuleHierarchyProvider.createChildren(root, scannerComponentIdGenerator, new HashMap<DefaultInputModule, DefaultInputModule>());
        DefaultInputModuleHierarchy inputModuleHierarchy = parents.isEmpty() ? new DefaultInputModuleHierarchy(root) : new DefaultInputModuleHierarchy(root, parents);
        workDirectoriesInit.execute(inputModuleHierarchy);
        return inputModuleHierarchy;
    }

    private static Map<DefaultInputModule, DefaultInputModule> createChildren(DefaultInputModule parent, ScannerComponentIdGenerator scannerComponentIdGenerator, Map<DefaultInputModule, DefaultInputModule> parents) {
        for (ProjectDefinition def : parent.definition().getSubProjects()) {
            DefaultInputModule child = InputModuleHierarchyProvider.createModule(def, scannerComponentIdGenerator.getAsInt());
            parents.put(child, parent);
            InputModuleHierarchyProvider.createChildren(child, scannerComponentIdGenerator, parents);
        }
        return parents;
    }

    private static DefaultInputModule createModule(ProjectDefinition def, int scannerComponentId) {
        LOG.debug("  Init module '{}'", (Object)def.getName());
        DefaultInputModule module = new DefaultInputModule(def, scannerComponentId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("    Base dir: {}", (Object)module.getBaseDir().toAbsolutePath());
            LOG.debug("    Working dir: {}", (Object)module.getWorkDir().toAbsolutePath());
            LOG.debug("    Module global encoding: {}, default locale: {}", (Object)module.getEncoding().displayName(), (Object)Locale.getDefault());
        }
        return module;
    }
}

