/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sca;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.scanner.config.DefaultConfiguration;

public class ScaProperties {
    private static final Pattern sonarScaPropertyRegex = Pattern.compile("^sonar\\.sca\\.([a-zA-Z]+)$");
    private static final String SONAR_SCA_PREFIX = "sonar.sca.";
    private static final Set<String> IGNORED_PROPERTIES = Set.of("sonar.sca.exclusions", "sonar.sca.excludedManifests", "sonar.sca.recursiveManifestSearch");

    private ScaProperties() {
    }

    public static Map<String, String> buildFromScannerProperties(DefaultConfiguration configuration) {
        HashMap<String, String> props = new HashMap<String, String>(configuration.getProperties());
        return props.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(SONAR_SCA_PREFIX)).filter(entry -> !IGNORED_PROPERTIES.contains(entry.getKey())).collect(Collectors.toMap(entry -> ScaProperties.convertPropToEnvVariable((String)entry.getKey()), Map.Entry::getValue));
    }

    private static String convertPropToEnvVariable(String propertyName) {
        Matcher regexMatcher = sonarScaPropertyRegex.matcher(propertyName);
        if (regexMatcher.matches() && regexMatcher.groupCount() == 1) {
            String tideliftNamespace = "TIDELIFT_";
            String convertedPropertyName = PropertyNamingStrategies.UpperSnakeCaseStrategy.INSTANCE.translate(regexMatcher.group(1));
            return tideliftNamespace + convertedPropertyName;
        }
        return propertyName;
    }
}

