/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sca;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.scanner.config.DefaultConfiguration;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.repository.featureflags.FeatureFlagsRepository;
import org.sonar.scanner.sca.CliCacheService;
import org.sonar.scanner.sca.CliService;

public class ScaExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(ScaExecutor.class);
    private static final String SCA_FEATURE_NAME = "sca";
    private final CliCacheService cliCacheService;
    private final CliService cliService;
    private final ReportPublisher reportPublisher;
    private final FeatureFlagsRepository featureFlagsRepository;
    private final DefaultConfiguration configuration;

    public ScaExecutor(CliCacheService cliCacheService, CliService cliService, ReportPublisher reportPublisher, FeatureFlagsRepository featureFlagsRepository, DefaultConfiguration configuration) {
        this.cliCacheService = cliCacheService;
        this.cliService = cliService;
        this.reportPublisher = reportPublisher;
        this.featureFlagsRepository = featureFlagsRepository;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DefaultInputModule root) {
        if (!this.featureFlagsRepository.isEnabled(SCA_FEATURE_NAME)) {
            LOG.info("Dependency analysis skipped");
            return;
        }
        if (!this.configuration.getBoolean("sonar.sca.enabled").orElse(true).booleanValue()) {
            LOG.info("Dependency analysis disabled for this project");
            return;
        }
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        LOG.info("Checking for latest CLI");
        File cliFile = this.cliCacheService.cacheCli();
        LOG.info("Collecting manifests for the dependency analysis...");
        if (cliFile.exists()) {
            try {
                File generatedZip = this.cliService.generateManifestsArchive(root, cliFile, this.configuration);
                LOG.debug("Zip ready for report: {}", (Object)generatedZip);
                this.reportPublisher.getWriter().writeScaFile(generatedZip);
                LOG.debug("Manifest zip written to report");
            }
            catch (IOException | IllegalStateException e) {
                LOG.error("Error gathering manifests", e);
            }
            finally {
                stopwatch.stop();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Load SCA project dependencies (done) | time={}ms", (Object)stopwatch.getTime(TimeUnit.MILLISECONDS));
                }
            }
        }
    }
}

