/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sca;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.System2;
import org.sonar.core.util.ProcessWrapperFactory;
import org.sonar.scanner.config.DefaultConfiguration;
import org.sonar.scanner.repository.TelemetryCache;
import org.sonar.scanner.sca.ScaProperties;
import org.sonar.scanner.scan.filesystem.ProjectExclusionFilters;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scm.git.JGitUtils;

public class CliService {
    private static final Logger LOG = LoggerFactory.getLogger(CliService.class);
    public static final String SCA_EXCLUSIONS_KEY = "sonar.sca.exclusions";
    public static final String LEGACY_SCA_EXCLUSIONS_KEY = "sonar.sca.excludedManifests";
    private final ProcessWrapperFactory processWrapperFactory;
    private final TelemetryCache telemetryCache;
    private final System2 system2;
    private final Server server;
    private final ScmConfiguration scmConfiguration;
    private final ProjectExclusionFilters projectExclusionFilters;

    public CliService(ProcessWrapperFactory processWrapperFactory, TelemetryCache telemetryCache, System2 system2, Server server, ScmConfiguration scmConfiguration, ProjectExclusionFilters projectExclusionFilters) {
        this.processWrapperFactory = processWrapperFactory;
        this.telemetryCache = telemetryCache;
        this.system2 = system2;
        this.server = server;
        this.scmConfiguration = scmConfiguration;
        this.projectExclusionFilters = projectExclusionFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateManifestsArchive(DefaultInputModule module, File cliExecutable, DefaultConfiguration configuration) throws IOException, IllegalStateException {
        File file;
        boolean success;
        long startTime;
        block9: {
            startTime = this.system2.now();
            success = false;
            Path excludesFilePath = null;
            try {
                String archiveName = "dependency-files.tar.xz";
                Path archivePath = module.getWorkDir().resolve(archiveName);
                ArrayList<String> args = new ArrayList<String>();
                args.add(cliExecutable.getAbsolutePath());
                args.add("projects");
                args.add("save-lockfiles");
                args.add("--xz");
                args.add("--xz-filename");
                args.add(archivePath.toAbsolutePath().toString());
                args.add("--directory");
                args.add(module.getBaseDir().toString());
                args.add("--recursive");
                excludesFilePath = this.createExcludesFile(module, configuration);
                if (excludesFilePath != null) {
                    args.add("--exclude-from-file");
                    args.add(excludesFilePath.toAbsolutePath().toString());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.info("Setting CLI to debug mode");
                    args.add("--debug");
                }
                HashMap<String, String> envProperties = new HashMap<String, String>();
                envProperties.put("TIDELIFT_SKIP_UPDATE_CHECK", "1");
                envProperties.put("TIDELIFT_ALLOW_MANIFEST_FAILURES", "1");
                envProperties.put("TIDELIFT_CLI_INSIDE_SCANNER_ENGINE", "1");
                envProperties.put("TIDELIFT_CLI_SQ_SERVER_VERSION", this.server.getVersion());
                envProperties.putAll(ScaProperties.buildFromScannerProperties(configuration));
                LOG.info("Running command: {}", (Object)args);
                LOG.info("Environment properties: {}", (Object)envProperties);
                Consumer<String> logConsumer = LOG.atLevel(Level.INFO)::log;
                this.processWrapperFactory.create(module.getWorkDir(), logConsumer, logConsumer, envProperties, args.toArray(new String[0])).execute();
                LOG.info("Generated manifests archive file: {}", (Object)archiveName);
                success = true;
                file = archivePath.toFile();
                if (excludesFilePath == null) break block9;
            }
            catch (Throwable throwable) {
                if (excludesFilePath != null) {
                    try {
                        Files.deleteIfExists(excludesFilePath);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to delete temporary exclusions file: {}", (Object)excludesFilePath, (Object)e);
                    }
                }
                this.telemetryCache.put("scanner.sca.execution.cli.duration", String.valueOf(this.system2.now() - startTime));
                this.telemetryCache.put("scanner.sca.execution.cli.success", String.valueOf(success));
                throw throwable;
            }
            try {
                Files.deleteIfExists(excludesFilePath);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete temporary exclusions file: {}", (Object)excludesFilePath, (Object)e);
            }
        }
        this.telemetryCache.put("scanner.sca.execution.cli.duration", String.valueOf(this.system2.now() - startTime));
        this.telemetryCache.put("scanner.sca.execution.cli.success", String.valueOf(success));
        return file;
    }

    public List<String> getAllExcludedPaths(DefaultInputModule module, DefaultConfiguration configuration) {
        List<String> configExcludedPaths = CliService.getConfigExcludedPaths(configuration, this.projectExclusionFilters);
        List<String> scmIgnoredPaths = this.getScmIgnoredPaths(module);
        ArrayList<String> mergedExclusionPaths = new ArrayList<String>();
        mergedExclusionPaths.addAll(configExcludedPaths);
        mergedExclusionPaths.addAll(scmIgnoredPaths);
        String workDirExcludedPath = CliService.getWorkDirExcludedPath(module);
        if (workDirExcludedPath != null) {
            mergedExclusionPaths.add(workDirExcludedPath);
        }
        return mergedExclusionPaths;
    }

    @Nullable
    private Path createExcludesFile(DefaultInputModule module, DefaultConfiguration configuration) throws IOException {
        List<String> mergedExclusionPaths = this.getAllExcludedPaths(module, configuration);
        if (mergedExclusionPaths.isEmpty()) {
            return null;
        }
        Path excludesFile = Files.createTempFile(module.getWorkDir(), "sca-exclusions-", ".txt", new FileAttribute[0]);
        Files.write(excludesFile, mergedExclusionPaths, new OpenOption[0]);
        return excludesFile;
    }

    private static List<String> getConfigExcludedPaths(DefaultConfiguration configuration, ProjectExclusionFilters projectExclusionFilters) {
        String[] sonarExclusions = projectExclusionFilters.getExclusionsConfig(InputFile.Type.MAIN);
        String[] scaExclusions = configuration.getStringArray(SCA_EXCLUSIONS_KEY);
        String[] scaExclusionsLegacy = configuration.getStringArray(LEGACY_SCA_EXCLUSIONS_KEY);
        return Stream.of(sonarExclusions, scaExclusions, scaExclusionsLegacy).flatMap(Arrays::stream).distinct().toList();
    }

    private List<String> getScmIgnoredPaths(DefaultInputModule module) {
        ScmProvider scmProvider = this.scmConfiguration.provider();
        if (scmProvider == null || scmProvider.key() == null || !scmProvider.key().equals("git")) {
            return List.of();
        }
        if (this.scmConfiguration.isExclusionDisabled()) {
            return List.of();
        }
        Path baseDirPath = module.getBaseDir();
        List<String> scmIgnoredPaths = JGitUtils.getAllIgnoredPaths(baseDirPath);
        if (scmIgnoredPaths.isEmpty()) {
            return List.of();
        }
        return scmIgnoredPaths.stream().map(ignoredPathRel -> {
            boolean isDirectory = false;
            try {
                isDirectory = Files.isDirectory(baseDirPath.resolve(ignoredPathRel.replace("/", File.separator)), new LinkOption[0]);
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            return isDirectory ? ignoredPathRel + "/**" : ignoredPathRel;
        }).toList();
    }

    private static String getWorkDirExcludedPath(DefaultInputModule module) {
        Path baseDir = module.getBaseDir().toAbsolutePath().normalize();
        Path workDir = module.getWorkDir().toAbsolutePath().normalize();
        if (workDir.startsWith(baseDir)) {
            Path relativeWorkDir = baseDir.relativize(workDir);
            String normalizedPath = relativeWorkDir.toString().replace('\\', '/');
            return normalizedPath + "/**";
        }
        return null;
    }
}

