/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sca;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.internal.apachecommons.lang3.SystemUtils;
import org.sonar.api.utils.System2;
import org.sonar.scanner.bootstrap.SonarUserHome;
import org.sonar.scanner.http.ScannerWsClient;
import org.sonar.scanner.repository.TelemetryCache;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.RequestWithoutPayload;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class CliCacheService {
    protected static final String CLI_WS_URL = "api/v2/sca/clis";
    private static final Logger LOG = LoggerFactory.getLogger(CliCacheService.class);
    private static final int RETRY_COUNT = 2;
    private static final int WAIT_TIME_MILLIS = 10000;
    private final SonarUserHome sonarUserHome;
    private final ScannerWsClient wsClient;
    private final TelemetryCache telemetryCache;
    private final System2 system2;
    private int waitTimeMillis;
    private int retryCount;

    public CliCacheService(SonarUserHome sonarUserHome, ScannerWsClient wsClient, TelemetryCache telemetryCache, System2 system2) {
        this.sonarUserHome = sonarUserHome;
        this.wsClient = wsClient;
        this.telemetryCache = telemetryCache;
        this.system2 = system2;
        this.retryCount = 2;
        this.waitTimeMillis = 10000;
    }

    static Path newTempFile(Path tempDir) {
        try {
            return Files.createTempFile(tempDir, "scaFileCache", null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create temp file in " + String.valueOf(tempDir), e);
        }
    }

    static void moveFile(Path sourceFile, Path targetFile) {
        block4: {
            try {
                Files.move(sourceFile, targetFile, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e1) {
                if (Files.exists(targetFile, new LinkOption[0])) break block4;
                LOG.warn("Unable to rename {} to {}", (Object)sourceFile, (Object)targetFile);
                LOG.warn("A copy/delete will be tempted but with no guarantee of atomicity");
                try {
                    Files.move(sourceFile, targetFile, new CopyOption[0]);
                }
                catch (IOException e2) {
                    throw new IllegalStateException("Fail to move " + String.valueOf(sourceFile) + " to " + String.valueOf(targetFile), e2);
                }
            }
        }
    }

    static void mkdir(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to create cache directory: " + String.valueOf(dir), e);
        }
    }

    static void downloadBinaryTo(Path downloadLocation, WsResponse response) {
        try (InputStream stream = response.contentStream();){
            FileUtils.copyInputStreamToFile(stream, downloadLocation.toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to download SCA CLI into %s", downloadLocation), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File cacheCli() {
        boolean success = false;
        String alternateLocation = this.system2.envVariable("TIDELIFT_CLI_LOCATION");
        if (alternateLocation != null) {
            LOG.info("Using alternate location for Tidelift CLI: {}", (Object)alternateLocation);
            File cliFile = new File(alternateLocation);
            if (!cliFile.exists()) {
                throw new IllegalStateException(String.format("Alternate location for Tidelift CLI has been set but no file was found at %s", alternateLocation));
            }
            return cliFile;
        }
        try {
            List<CliMetadataResponse> metadataResponses = this.getLatestMetadata(this.apiOsName(), this.apiArch());
            if (metadataResponses.isEmpty()) {
                throw new IllegalStateException(String.format("Could not find CLI for %s %s", this.apiOsName(), this.apiArch()));
            }
            if (metadataResponses.size() > 1) {
                throw new IllegalStateException("Multiple CLI matches found. Unable to correctly cache CLI.");
            }
            CliMetadataResponse metadataResponse = metadataResponses.get(0);
            String checksum = metadataResponse.sha256();
            if (!this.cachedCliFile(checksum).exists()) {
                LOG.debug("SCA CLI update detected");
                this.downloadCli(metadataResponse.id(), checksum);
                this.telemetryCache.put("scanner.sca.get.cli.cache.hit", "false");
            } else {
                this.telemetryCache.put("scanner.sca.get.cli.cache.hit", "true");
            }
            File cliFile = this.cachedCliFile(checksum);
            success = true;
            File file = cliFile;
            return file;
        }
        finally {
            this.telemetryCache.put("scanner.sca.get.cli.success", String.valueOf(success));
        }
    }

    Path cacheDir() {
        return this.sonarUserHome.getPath().resolve("cache");
    }

    private File cachedCliFile(String checksum) {
        return this.cacheDir().resolve(checksum).resolve(this.fileName()).toFile();
    }

    private String fileName() {
        return this.system2.isOsWindows() ? "tidelift.exe" : "tidelift";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CliMetadataResponse> getLatestMetadata(String osName, String arch) {
        LOG.info("Requesting CLI for OS {} and arch {}", (Object)osName, (Object)arch);
        GetRequest getRequest = (GetRequest)((RequestWithoutPayload)new GetRequest(CLI_WS_URL).setParam("os", osName)).setParam("arch", arch);
        WsResponse response = CliCacheService.retryCall(this.wsClient, getRequest, this.retryCount, this.waitTimeMillis);
        if (response != null) {
            List list;
            block11: {
                Reader reader = response.contentReader();
                try {
                    Type listOfMetadata = new TypeToken<ArrayList<CliMetadataResponse>>(){}.getType();
                    list = (List)new Gson().fromJson(reader, listOfMetadata);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOG.error("Unable to parse CLI metadata: ", e);
                            response.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        response.close();
                        throw throwable3;
                    }
                }
                reader.close();
            }
            response.close();
            return list;
        }
        return List.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadCli(String id, String checksum) {
        LOG.info("Downloading cli {}", (Object)id);
        long startTime = this.system2.now();
        GetRequest getRequest = (GetRequest)new GetRequest("api/v2/sca/clis/" + id).setHeader("Accept", "application/octet-stream");
        boolean success = false;
        try {
            WsResponse response;
            try {
                response = CliCacheService.retryCall(this.wsClient, getRequest, this.retryCount, this.waitTimeMillis);
            }
            catch (HttpException e) {
                throw new IllegalStateException("Unable to download CLI executable");
            }
            if (response == null) {
                throw new IllegalStateException("Unable to download CLI executable");
            }
            Path tempDir = this.createTempDir();
            Path tempFile = CliCacheService.newTempFile(tempDir);
            CliCacheService.downloadBinaryTo(tempFile, response);
            response.close();
            File destinationFile = this.cachedCliFile(checksum);
            CliCacheService.mkdir(destinationFile.toPath().getParent());
            CliCacheService.moveFile(tempFile, destinationFile.toPath());
            if (!destinationFile.setExecutable(true, false)) {
                throw new IllegalStateException("Unable to mark CLI as executable");
            }
            success = true;
        }
        finally {
            this.telemetryCache.put("scanner.sca.download.cli.duration", String.valueOf(this.system2.now() - startTime));
            this.telemetryCache.put("scanner.sca.download.cli.success", String.valueOf(success));
        }
    }

    @Nullable
    static WsResponse retryCall(ScannerWsClient wsClient, WsRequest request, int retryCount, int waitTimeMillis) {
        WsResponse response = null;
        while (retryCount >= 0) {
            try {
                response = wsClient.call(request);
                break;
            }
            catch (HttpException e) {
                if (retryCount == 0) {
                    throw e;
                }
                try {
                    CliCacheService.sleep(waitTimeMillis);
                }
                catch (InterruptedException interruptedException) {
                    LOG.warn("Data retrieval call interrupted while waiting to retry, will not retry.");
                    Thread.currentThread().interrupt();
                    retryCount = 0;
                }
                --retryCount;
            }
        }
        return response;
    }

    public static void sleep(int waitTimeMillis) throws InterruptedException {
        Thread.sleep(waitTimeMillis);
    }

    String apiOsName() {
        if (this.system2.isOsWindows()) {
            return "windows";
        }
        if (this.system2.isOsMac()) {
            return "mac";
        }
        return "linux";
    }

    String apiArch() {
        return SystemUtils.OS_ARCH.toLowerCase(Locale.ENGLISH);
    }

    Path createTempDir() {
        Path dir = this.sonarUserHome.getPath().resolve("_tmp");
        try {
            if (Files.exists(dir, new LinkOption[0])) {
                return dir;
            }
            return Files.createDirectory(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create temp directory at " + String.valueOf(dir), e);
        }
    }

    public void setWaitTimeMillis(int waitTimeMillis) {
        this.waitTimeMillis = waitTimeMillis;
    }

    private record CliMetadataResponse(String id, String filename, String sha256, String os, String arch) {
    }
}

