/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.DateUtils;
import org.sonar.scanner.http.ScannerWsClient;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonar.scanner.rule.LoadedActiveRule;
import org.sonarqube.ws.client.GetRequest;

public class DefaultActiveRulesLoader
implements ActiveRulesLoader {
    private static final String RULES_ACTIVE_URL = "/api/v2/analysis/active_rules?";
    private final ScannerWsClient wsClient;

    public DefaultActiveRulesLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public List<LoadedActiveRule> load(String projectKey) {
        List jsonResponse;
        GetRequest getRequest = new GetRequest(DefaultActiveRulesLoader.getUrl(projectKey));
        try (Reader reader = this.wsClient.call(getRequest).contentReader();){
            jsonResponse = (List)new Gson().fromJson(reader, new TypeToken<ArrayList<ActiveRuleGson>>(){}.getType());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load active rules", e);
        }
        return DefaultActiveRulesLoader.convert(jsonResponse);
    }

    private static String getUrl(String projectKey) {
        return "/api/v2/analysis/active_rules?projectKey=" + projectKey;
    }

    private static List<LoadedActiveRule> convert(List<ActiveRuleGson> activeRuleGsonList) {
        return activeRuleGsonList.stream().map(DefaultActiveRulesLoader::convertActiveRule).toList();
    }

    private static LoadedActiveRule convertActiveRule(ActiveRuleGson activeRule) {
        LoadedActiveRule loadedRule = new LoadedActiveRule();
        loadedRule.setRuleKey(DefaultActiveRulesLoader.convertRuleKey(activeRule.ruleKey()));
        loadedRule.setName(activeRule.name());
        loadedRule.setSeverity(activeRule.severity());
        loadedRule.setCreatedAt(DateUtils.dateToLong(DateUtils.parseDateTime(activeRule.createdAt())));
        loadedRule.setUpdatedAt(DateUtils.dateToLong(DateUtils.parseDateTime(activeRule.updatedAt())));
        loadedRule.setLanguage(activeRule.language());
        loadedRule.setInternalKey(activeRule.internalKey());
        loadedRule.setQProfileKey(activeRule.qProfileKey());
        Optional.ofNullable(activeRule.templateRuleKey()).map(RuleKey::parse).map(RuleKey::rule).ifPresent(loadedRule::setTemplateRuleKey);
        loadedRule.setParams(activeRule.params() != null ? DefaultActiveRulesLoader.convertParams(activeRule.params()) : Map.of());
        loadedRule.setImpacts(activeRule.impacts() != null ? activeRule.impacts() : Map.of());
        loadedRule.setDeprecatedKeys(DefaultActiveRulesLoader.convertDeprecatedKeys(activeRule.deprecatedKeys()));
        return loadedRule;
    }

    private static Map<String, String> convertParams(List<ParamGson> params) {
        return params.stream().collect(Collectors.toMap(ParamGson::key, ParamGson::value));
    }

    private static Set<RuleKey> convertDeprecatedKeys(@Nullable List<RuleKeyGson> deprecatedKeysList) {
        return Optional.ofNullable(deprecatedKeysList).orElse(List.of()).stream().map(value -> RuleKey.of(value.repository(), value.rule())).collect(Collectors.toSet());
    }

    private static RuleKey convertRuleKey(RuleKeyGson ruleKey) {
        return RuleKey.of(ruleKey.repository(), ruleKey.rule());
    }

    record ActiveRuleGson(@SerializedName(value="ruleKey") RuleKeyGson ruleKey, @SerializedName(value="name") String name, @SerializedName(value="severity") String severity, @SerializedName(value="createdAt") String createdAt, @SerializedName(value="updatedAt") String updatedAt, @SerializedName(value="internalKey") @Nullable String internalKey, @SerializedName(value="language") String language, @SerializedName(value="templateRuleKey") @Nullable String templateRuleKey, @SerializedName(value="qProfileKey") String qProfileKey, @SerializedName(value="deprecatedKeys") @Nullable List<RuleKeyGson> deprecatedKeys, @SerializedName(value="params") @Nullable List<ParamGson> params, @SerializedName(value="impacts") @Nullable Map<SoftwareQuality, Severity> impacts) {
    }

    record RuleKeyGson(@SerializedName(value="repository") String repository, @SerializedName(value="rule") String rule) {
    }

    record ParamGson(@SerializedName(value="key") String key, @SerializedName(value="value") String value) {
    }
}

