/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.util.Map;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.DefaultActiveRules;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonar.scanner.rule.LoadedActiveRule;
import org.springframework.context.annotation.Bean;

public class ActiveRulesProvider {
    private static final Logger LOG = Loggers.get(ActiveRulesProvider.class);
    private static final String LOG_MSG = "Load active rules";

    @Bean(value={"ActiveRules"})
    public DefaultActiveRules provide(ActiveRulesLoader loader, ScannerProperties props) {
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG);
        DefaultActiveRules activeRules = ActiveRulesProvider.load(loader, props.getProjectKey());
        profiler.stopInfo();
        return activeRules;
    }

    private static DefaultActiveRules load(ActiveRulesLoader loader, String projectKey) {
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        loader.load(projectKey).stream().map(ActiveRulesProvider::transform).forEach(builder::addRule);
        return builder.build();
    }

    private static NewActiveRule transform(LoadedActiveRule activeRule) {
        NewActiveRule.Builder builder = new NewActiveRule.Builder();
        builder.setRuleKey(activeRule.getRuleKey()).setName(activeRule.getName()).setSeverity(activeRule.getSeverity()).setCreatedAt(activeRule.getCreatedAt()).setUpdatedAt(activeRule.getUpdatedAt()).setLanguage(activeRule.getLanguage()).setInternalKey(activeRule.getInternalKey()).setTemplateRuleKey(activeRule.getTemplateRuleKey()).setQProfileKey(activeRule.getQProfileKey()).setDeprecatedKeys(activeRule.getDeprecatedKeys());
        if (activeRule.getParams() != null) {
            for (Map.Entry<Object, Object> entry : activeRule.getParams().entrySet()) {
                builder.setParam((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (activeRule.getImpacts() != null) {
            for (Map.Entry<Object, Object> entry : activeRule.getImpacts().entrySet()) {
                builder.setImpact((SoftwareQuality)((Object)entry.getKey()), (Severity)((Object)entry.getValue()));
            }
        }
        return builder.build();
    }
}

