/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository.language;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.Startable;
import org.sonar.scanner.repository.language.Language;
import org.sonar.scanner.repository.language.LanguagesLoader;
import org.sonar.scanner.repository.language.LanguagesRepository;

@Immutable
public class DefaultLanguagesRepository
implements LanguagesRepository,
Startable {
    private final Map<String, Language> languages = new HashMap<String, Language>();
    private final LanguagesLoader languagesLoader;

    public DefaultLanguagesRepository(LanguagesLoader languagesLoader) {
        this.languagesLoader = languagesLoader;
    }

    @Override
    public void start() {
        this.languages.putAll(this.languagesLoader.load());
    }

    @Override
    @CheckForNull
    public Language get(String languageKey) {
        return this.languages.get(languageKey);
    }

    @Override
    public Collection<Language> all() {
        return this.languages.values();
    }

    @Override
    public void stop() {
    }
}

